---
generated_at: 2026-02-01 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-aarch64バックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **BTI（Branch Target Identification）サポート**：ソースコード内での明示的な実装確認が必要
  2. **スタックプローブの挿入可能性**：実装箇所の特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen/aarch64/Select.zig` - 命令選択モジュール
- E-02: `src/codegen/aarch64/Mir.zig` - MIR構造体とリロケーション定義
- E-03: `src/codegen/aarch64/encoding.zig` - Register型とInstruction型
- E-04: `src/codegen/aarch64/abi.zig` - 呼び出し規約定義
- E-05: `src/codegen/aarch64/Assemble.zig` - アセンブル処理
- E-06: `src/codegen/aarch64/Disassemble.zig` - 逆アセンブル処理
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRをARM64マシンコードに変換する | E-01, E-02 | ○ |
| C-02 | Select構造体でレジスタ追跡を行う | E-01 (行20-27) | ○ |
| C-03 | MIR構造体にprologue/body/epilogueを持つ | E-02 (行1-9) | ○ |
| C-04 | Reloc型にNav/Uav/Lazy/Global/Literalがある | E-02 (行11-38) | ○ |
| C-05 | レジスタはx0-x30、v0-v31をサポート | E-03 (行98-200) | ○ |
| C-06 | 32ビット固定長命令形式を使用 | E-03, E-02 | ○ |
| C-07 | emit関数でバイナリ出力を行う | E-02 (行53-170) | ○ |
| C-08 | analyze関数でAIR命令を変換する | E-01 (行127以降) | ○ |
| C-09 | ELFリンカ・MachOリンカと連携する | E-02 (行134-156) | ○ |
| C-10 | 16バイトスタックアライメントを使用 | E-01, E-04 | ○ |
| C-11 | x19-x28がカリーセーブレジスタ | E-04 | ○ |
| C-12 | deinit関数でリソースを解放する | E-01 (行102-125) | ○ |
| C-13 | OutOfRegistersエラーが発生し得る | E-01 | ○ |
| C-14 | CodeGenFailエラーが発生し得る | E-01 | ○ |
| C-15 | リテラルプールをサポート | E-02 (行4, 27) | ○ |
| C-16 | PC相対アドレッシングを使用 | E-02 | ○ |
| C-17 | BTI（Branch Target Identification）をサポート | **根拠なし** | △ |
| C-18 | スタックプローブを挿入可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BTI（Branch Target Identification）サポートの実装箇所
  - 候補：encoding.zig / abi.zig / 別ファイル
- スタックプローブ挿入機能の実装詳細
  - 候補：Select.zig / プロローグ生成コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード生成機能は明確に実装されている
- 1: 中リスク - セキュリティ関連機能（BTI、スタックプローブ）の実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 Select.zigのanalyze関数でAIR命令の網羅性を確認
- [ ] E-02 Mir.zigのemit関数でリロケーション処理の正確性を確認
- [ ] BTIサポートの有無をencoding.zig内で検索して確認
- [ ] スタックプローブ挿入コードの有無を確認
- [ ] AAPCS呼び出し規約準拠をabi.zigで確認
