---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-riscv64バックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **CFI（Control Flow Integrity）拡張対応**：将来機能として記載されているが実装状況不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen/riscv64/CodeGen.zig` - メインコード生成モジュール
- E-02: `src/codegen/riscv64/Mir.zig` - MIR構造体定義
- E-03: `src/codegen/riscv64/Lower.zig` - 命令下降処理
- E-04: `src/codegen/riscv64/Emit.zig` - バイナリ出力
- E-05: `src/codegen/riscv64/bits.zig` - 基本型定義
- E-06: `src/codegen/riscv64/mnem.zig` - 命令ニーモニック
- E-07: `src/codegen/riscv64/encoding.zig` - 命令エンコーディング
- E-08: `src/codegen/riscv64/abi.zig` - 呼び出し規約
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRをRISC-V 64bitマシンコードに変換する | E-01, E-02 | ○ |
| C-02 | legalizeFeatures関数でsafe演算展開を設定 | E-01 (行54-63) | ○ |
| C-03 | MCValue型で値表現を管理 | E-01 (行157-200) | ○ |
| C-04 | MIR.Instに複数の命令形式(r/i/s/b/u/j_type)がある | E-02 (行13-93) | ○ |
| C-05 | x0-x31汎用レジスタをサポート | E-05 | ○ |
| C-06 | f0-f31浮動小数点レジスタをサポート | E-05 | ○ |
| C-07 | VType型でベクトル拡張をサポート | E-01 (行107-108), E-05 | ○ |
| C-08 | Lower.zigで命令下降を行う | E-03 | ○ |
| C-09 | Emit.zigでバイナリ出力を行う | E-04 | ○ |
| C-10 | Mnemonic列挙型で命令名を定義 | E-06 | ○ |
| C-11 | abi.zigで呼び出し規約を定義 | E-08 | ○ |
| C-12 | RegisterManagerでレジスタ管理 | E-01 (行112), E-08 | ○ |
| C-13 | mir_instructions/frame_locsを出力 | E-02 (行4-5) | ○ |
| C-14 | OutOfRegistersエラーが発生し得る | E-01 (行52) | ○ |
| C-15 | LowerFail/EmitFailエラーが発生し得る | E-02 (行143-146) | ○ |
| C-16 | InvalidInstructionエラーが発生し得る | E-02 (行145) | ○ |
| C-17 | デバッグ情報（行番号・列番号）を生成 | E-02 (行89-92) | ○ |
| C-18 | branch_stackでブランチ管理 | E-01 (行97-104) | ○ |
| C-19 | フレーム割り当てを管理 | E-01 (行117-119) | ○ |
| C-20 | CFI（Control Flow Integrity）拡張対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CFI（Control Flow Integrity）拡張の実装状況
  - 候補：encoding.zig / abi.zig / 将来実装予定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なコード生成機能は明確に実装されている
- 0: 低リスク - ベクトル拡張（RVV）サポートも確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 CodeGen.zigのMCValue型が全値種別をカバーしているか確認
- [ ] E-02 Mir.zigの命令形式が全RISC-V命令をカバーしているか確認
- [ ] E-05 bits.zigのVType定義がRVV仕様に準拠しているか確認
- [ ] E-08 abi.zigの呼び出し規約がRISC-V標準に準拠しているか確認
- [ ] ベクトル拡張（RVV）の実装完成度を確認
