---
generated_at: 2026-02-01 17:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-wasmバックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen/wasm/CodeGen.zig` - メインコード生成モジュール
- E-02: `src/codegen/wasm/Mir.zig` - MIR構造体定義
- E-03: `src/codegen/wasm/Emit.zig` - バイナリ出力
- E-04: `src/codegen/wasm/abi.zig` - WASM ABI定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRをWebAssemblyバイトコードに変換する | E-01, E-02 | ○ |
| C-02 | legalizeFeatures関数でsafe演算展開を設定 | E-01 (行31-43) | ○ |
| C-03 | WValue型でスタック/ローカル値を表現 | E-01 (行143-188) | ○ |
| C-04 | owner_navフィールドで関数を識別 | E-01 (行44) | ○ |
| C-05 | block_depthでブロック深度を管理 | E-01 (行47) | ○ |
| C-06 | branchesでブランチを管理 | E-01 (行56) | ○ |
| C-07 | simd_immediatesでSIMD128即値を管理 | E-01 (行76) | ○ |
| C-08 | ptr_sizeでwasm32/wasm64を区別 | E-01 (行79) | ○ |
| C-09 | mir_instructionsに命令を出力 | E-01 (行82) | ○ |
| C-10 | mir_localsにローカル変数型を出力 | E-01 (行87) | ○ |
| C-11 | mir_uavsにUAV参照を出力 | E-01 (行90) | ○ |
| C-12 | mir_indirect_function_setに間接呼び出し関数を出力 | E-01 (行93) | ○ |
| C-13 | mir_func_tysに関数型を出力 | E-01 (行95) | ○ |
| C-14 | 型別フリーリストでローカル変数を再利用 | E-01 (行120-136) | ○ |
| C-15 | 16バイトスタックアライメントを使用 | E-01 (行118) | ○ |
| C-16 | error_name_table_ref_countでエラー名テーブル参照をカウント | E-01 (行97) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 CodeGen.zigのWValue型が全値種別をカバーしているか確認
- [ ] E-02 Mir.zigの命令構造がWASM仕様に準拠しているか確認
- [ ] E-04 abi.zigの呼び出し規約がWASM ABIに準拠しているか確認
- [ ] SIMD128サポートの実装完成度を確認
