---
generated_at: 2026-02-01 17:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Cバックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen/c.zig` - メインCバックエンドモジュール
- E-02: `src/codegen/c/Type.zig` - C型定義（参照のみ、未読込）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRをCソースコードに変換する | E-01 | ○ |
| C-02 | legalizeFeatures関数でdev.envに応じて機能を設定 | E-01 (行26-43) | ○ |
| C-03 | Mir構造体でcode_header/code/fwd_decl/ctype_pool/lazy_fnsを管理 | E-01 (行52-74) | ○ |
| C-04 | CValue型でlocal/constant/nav/arg等を表現 | E-01 (行80-159) | ○ |
| C-05 | LazyFnKey/LazyFnValueで遅延関数を管理 | E-01 (行168-177) | ○ |
| C-06 | Local構造体でローカル変数を管理 | E-01 (行178-193) | ○ |
| C-07 | LocalIndexはu16型 | E-01 (行190) | ○ |
| C-08 | CType.AlignAsでアライメントを指定 | E-01 (行180-183) | ○ |
| C-09 | uavsでUAV参照を管理 | E-01 (行58) | ○ |
| C-10 | CValueにeql関数で等価比較を実装 | E-01 (行106-158) | ○ |
| C-11 | BlockDataでブロック管理 | E-01 (行161-164) | ○ |
| C-12 | CValueMapでAir.Inst.RefからCValueへのマッピング | E-01 (行166) | ○ |
| C-13 | LazyFnMapでLazyFnKeyからLazyFnValueへのマッピング | E-01 (行176) | ○ |
| C-14 | expand_packed_*機能を有効化 | E-01 (行37-40) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 c.zigのCValue型が全値種別をカバーしているか確認
- [ ] E-01 Mir構造体の出力形式が正しいか確認
- [ ] E-02 c/Type.zigのCType定義を詳細確認
- [ ] 生成されるCコードがC99/C11標準に準拠しているか確認
