---
generated_at: 2026-02-01 17:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-sparc64バックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen/sparc64/CodeGen.zig` - メインコード生成モジュール
- E-02: `src/codegen/sparc64/Mir.zig` - MIR構造体定義
- E-03: `src/codegen/sparc64/Emit.zig` - バイナリ出力
- E-04: `src/codegen/sparc64/bits.zig` - 基本型定義
- E-05: `src/codegen/sparc64/abi.zig` - 呼び出し規約
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRをSPARC V9マシンコードに変換する | E-01, E-02 | ○ |
| C-02 | legalizeFeatures関数はnullを返す | E-01 (行44-46) | ○ |
| C-03 | RegisterView列挙型でcaller/callee視点を管理 | E-01 (行48-51) | ○ |
| C-04 | MCValue型でregister/immediate/memory等を表現 | E-01 (行118-200) | ○ |
| C-05 | condition_flagsでCCR条件を管理 | E-01 (行158-161) | ○ |
| C-06 | condition_registerで条件レジスタを管理 | E-01 (行163-168) | ○ |
| C-07 | register_with_overflowでオーバーフロー検出を管理 | E-01 (行140-143) | ○ |
| C-08 | stack_offsetでスタック変数を管理 | E-01 (行152) | ○ |
| C-09 | realStackOffset()でスタックバイアスを適用 | E-01 (行150-151) | ○ |
| C-10 | branch_stackでブランチを管理 | E-01 (行91) | ○ |
| C-11 | register_managerでレジスタを管理 | E-01 (行96) | ○ |
| C-12 | bits.zigでInstruction.ASI/ShiftWidthを定義 | E-04, E-01 (行32-34) | ○ |
| C-13 | abi.zigでRegisterManager/RegisterClassを定義 | E-05, E-01 (行35-38) | ○ |
| C-14 | medium/lowコードモデルのみ対応（コメント記載） | E-01 (行1-4) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる
- 1: 中リスク - 他のコードモデル（high等）への対応がTODO状態

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 CodeGen.zigのMCValue型が全値種別をカバーしているか確認
- [ ] E-04 bits.zigのInstruction定義がSPARC V9仕様に準拠しているか確認
- [ ] E-05 abi.zigの呼び出し規約がSPARC V9 ABIに準拠しているか確認
- [ ] スタックバイアス（2047バイト）の適用が正しいか確認
