---
generated_at: 2026-02-01 18:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-MachOリンカ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/MachO.zig` - メインMachOリンカモジュール
- E-02: `src/link/MachO/Atom.zig` - Atom構造体（参照）
- E-03: `src/link/MachO/Relocation.zig` - リロケーション処理（参照）
- E-04: `src/link/MachO/DebugSymbols.zig` - dSYM管理（参照）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mach-O形式のリンカ機能を提供する | E-01, E-05 | ○ |
| C-02 | files MultiArrayListで入力ファイルを管理 | E-01 (行15) | ○ |
| C-03 | d_symでDebugSymbolsを管理 | E-01 (行10) | ○ |
| C-04 | segments ArrayListでセグメントを管理 | E-01 (行25) | ○ |
| C-05 | sections MultiArrayListでセクションを管理 | E-01 (行26) | ○ |
| C-06 | dyld_info_cmdでdyld情報を管理 | E-01 (行36) | ○ |
| C-07 | symtab_cmdでシンボルテーブルを管理 | E-01 (行37) | ○ |
| C-08 | codesig_cmdでコード署名を管理 | E-01 (行42) | ○ |
| C-09 | pagezero_seg_indexでPAGEZEROを管理 | E-01 (行44) | ○ |
| C-10 | stubs_sect_indexでスタブを管理 | E-01 (行50) | ○ |
| C-11 | stubs_helper_sect_indexでスタブヘルパーを管理 | E-01 (行51) | ○ |
| C-12 | la_symbol_ptr_sect_indexで遅延シンボルポインタを管理 | E-01 (行52) | ○ |
| C-13 | export_trieでエクスポート情報を管理 | E-01 (行74) | ○ |
| C-14 | createEmpty関数で初期化処理を行う | E-01 (行160以降) | ○ |
| C-15 | pagezero_sizeでPAGEZEROサイズを設定 | E-01 (行109) | ○ |
| C-16 | headerpad_sizeでヘッダーパッドを設定 | E-01 (行111) | ○ |
| C-17 | hot_stateでホットコードスワップを管理 | E-01 (行143) | ○ |
| C-18 | Frameworkでフレームワーク情報を管理 | E-01 (行146-150) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 MachO.zigのセグメント管理が完全か確認
- [ ] E-01 ロードコマンド生成が正しいか確認
- [ ] E-01 コード署名処理の正確性を確認
- [ ] E-04 DebugSymbols.zigのdSYM生成を確認
