---
generated_at: 2026-02-01 18:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-COFFリンカ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/Coff.zig` - メインCOFF/PEリンカモジュール
- E-02: `src/link/MappedFile.zig` - メモリマップドファイル（参照）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COFF/PE形式のリンカ機能を提供する | E-01, E-03 | ○ |
| C-02 | mfでMappedFileを管理 | E-01 (行22) | ○ |
| C-03 | nodesでPE構造ノードを管理 | E-01 (行23) | ○ |
| C-04 | import_tableでインポートテーブルを管理 | E-01 (行24) | ○ |
| C-05 | symbol_tableでシンボルテーブルを管理 | E-01 (行35) | ○ |
| C-06 | globalsでグローバルシンボルを管理 | E-01 (行36) | ○ |
| C-07 | navsでNav参照を管理 | E-01 (行38) | ○ |
| C-08 | uavsでUAV参照を管理 | E-01 (行39) | ○ |
| C-09 | msdos_stub定数でMS-DOSスタブを定義 | E-01 (行67-117) | ○ |
| C-10 | Node型でPE構造要素を表現 | E-01 (行119-255) | ○ |
| C-11 | ImportTable構造体でインポート情報を管理 | E-01 (行257-293) | ○ |
| C-12 | String型でセクション名を管理 | E-01 (行295以降) | ○ |
| C-13 | default_file_alignment = 0x200 | E-01 (行52) | ○ |
| C-14 | default_size_of_stack_reserve = 0x1000000 | E-01 (行53) | ○ |
| C-15 | default_size_of_heap_reserve = 0x100000 | E-01 (行55) | ○ |
| C-16 | MS-DOSスタブに「This program cannot be run in DOS mode.」を含む | E-01 (行112) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 Coff.zigのNode型が全PE構造をカバーしているか確認
- [ ] E-01 ImportTable構造体が正しいか確認
- [ ] E-01 セクション配置ロジックの正確性を確認
- [ ] E-01 リロケーション処理の正確性を確認
