---
generated_at: 2026-02-01 18:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-WASMリンカ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/Wasm.zig` - メインWASMリンカモジュール
- E-02: `src/link/Wasm/Object.zig` - オブジェクトファイル処理（参照）
- E-03: `src/link/Wasm/Archive.zig` - アーカイブ処理（参照）
- E-04: `src/link/Wasm/Flush.zig` - 出力処理（参照）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebAssemblyモジュールをリンクする | E-01, E-05 | ○ |
| C-02 | string_bytesで文字列バイト列を管理 | E-01 (行57) | ○ |
| C-03 | string_tableで文字列テーブルを管理 | E-01 (行63) | ○ |
| C-04 | entry_nameでエントリ関数名を管理 | E-01 (行65) | ○ |
| C-05 | func_typesで関数型を管理 | E-01 (行83) | ○ |
| C-06 | object_function_importsで関数インポートを管理 | E-01 (行87) | ○ |
| C-07 | object_functionsでオブジェクト関数を管理 | E-01 (行89) | ○ |
| C-08 | object_global_importsでグローバルインポートを管理 | E-01 (行93) | ○ |
| C-09 | object_globalsでオブジェクトグローバルを管理 | E-01 (行95) | ○ |
| C-10 | object_data_segmentsでデータセグメントを管理 | E-01 (行118) | ○ |
| C-11 | object_init_funcsで初期化関数を管理 | E-01 (行113) | ○ |
| C-12 | navs_obj/navs_exeでNav参照を管理 | E-01 (行177-180) | ○ |
| C-13 | uavs_obj/uavs_exeでUAV参照を管理 | E-01 (行184-186) | ○ |
| C-14 | zcu_funcsでZcu関数を管理 | E-01 (行191) | ○ |
| C-15 | mir_instructionsでMIR命令を管理 | E-01 (行281) | ○ |
| C-16 | mir_extraでMIR追加データを管理 | E-01 (行283) | ○ |
| C-17 | mir_localsでMIRローカル変数を管理 | E-01 (行285) | ○ |
| C-18 | flush_bufferでFlush処理を管理 | E-01 (行198) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全て根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 Wasm.zigの関数型インターン化が正しいか確認
- [ ] E-01 データセグメント配置ロジックの正確性を確認
- [ ] E-04 Flush.zigの出力処理がWASM仕様に準拠しているか確認
- [ ] 間接呼び出しテーブルの構築が正しいか確認
