---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-LLDリンカ統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **LLDの子プロセス実行理由**：コメントに記載があるが外部資料未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/Lld.zig` - Lld構造体定義（1-250行目）
- E-02: `src/link/Lld.zig` - flush関数（253-283行目）
- E-03: `src/link/Lld.zig` - coffLink関数（359-744行目）
- E-04: `src/link/Lld.zig` - elfLink関数（757行目以降）
- E-05: `src/link/Lld.zig` - linkAsArchive関数（285-357行目）
- E-06: `src/link/Lld.zig` - Coff構造体（8-73行目）
- E-07: `src/link/Lld.zig` - Elf構造体（74-159行目）
- E-08: `src/link/Lld.zig` - Wasm構造体（160-198行目）
- E-09: `src/link.zig` - Tag.lld定義
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.42の定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLDはライブラリとして動作せずexit()を呼ぶため子プロセス実行 | E-03 (417-419行目コメント) | ○ |
| C-02 | ofmtはunion型でelf/coff/wasmの設定を保持 | E-01 (2-6行目) | ○ |
| C-03 | flush関数がリンク処理のエントリーポイント | E-02 | ○ |
| C-04 | coffLinkではlld-linkコマンドを使用 | E-03 (420行目) | ○ |
| C-05 | elfLinkではld.lldコマンドを使用 | E-04 (837行目) | ○ |
| C-06 | 静的ライブラリはlinkAsArchiveで処理 | E-02, E-05 | ○ |
| C-07 | イメージベースアドレスはアーキテクチャ依存 | E-06 (36-48行目) | ○ |
| C-08 | デフォルトスタックサイズは16MB | E-01 (221-225行目) | ○ |
| C-09 | WASM freestandingは1MBスタック | E-01 (222-223行目) | ○ |
| C-10 | LTOレベルはoptimize_modeに依存 | E-03 (450-456行目), E-04 (861-867行目) | ○ |
| C-11 | BPF、m68k、SPARCはLLDの制限で特殊処理 | E-04 (797-804行目) | ○ |
| C-12 | UEFIとWin32で設定が分岐 | E-03 (610-677行目) | ○ |
| C-13 | CRTリンク時にlibcmtやmsvcrt等を追加 | E-03 (641-661行目) | ○ |
| C-14 | DLLインポートライブラリ検索ロジック | E-03 (716-741行目) | ○ |
| C-15 | サブシステム推論ロジック | E-03 (560-581行目) | ○ |
| C-16 | 画面No.3と関連（補助機能） | E-11 | ○ |
| C-17 | wasmLink関数が存在する | E-02 (277行目) | ○ |
| C-18 | Zigネイティブリンカが成熟すればLLD依存削減 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Zigネイティブリンカのロードマップ（C-18）
  - 候補：プロジェクトロードマップ / GitHub Issues / 開発者ブログ

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ソースコードから直接確認可能な事実が大半
- **0（低リスク）**: 処理フローはコード構造と一致

## 6) レビュアーチェックリスト（最小）
- [ ] flush関数の分岐ロジックがドキュメントと一致しているか
- [ ] イメージベースアドレスの値がCoff.init関数と一致しているか
- [ ] LLDの子プロセス実行に関するコメントが最新か
- [ ] wasmLink関数の存在と動作を確認
- [ ] 将来のZigネイティブリンカ計画について開発コミュニティに確認
