---
generated_at: 2026-02-01 17:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-値システム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Value.zig` - ip_indexフィールド定義（19行目）
- E-02: `src/Value.zig` - format関数のcompileError（21-25行目）
- E-03: `src/Value.zig` - fmtValue関数（37-44行目）
- E-04: `src/Value.zig` - toIpString関数（61-80行目）
- E-05: `src/Value.zig` - toAllocatedBytes関数（84-102行目）
- E-06: `src/Value.zig` - fromInterned関数（134-137行目）
- E-07: `src/Value.zig` - toIntern関数（139-142行目）
- E-08: `src/Value.zig` - toBigInt関数（180-186行目）
- E-09: `src/Value.zig` - getFunction関数（229-234行目）
- E-10: `src/Value.zig` - getVariable関数（236-241行目）
- E-11: `src/Value.zig` - getUnsignedInt関数（245-252行目）
- E-12: `src/Value.zig` - getUnsignedIntInner関数（260-299行目）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.45の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ValueはInternPool.Indexをラップする | E-01 | ○ |
| C-02 | ip_indexフィールドで値インデックスを保持 | E-01 | ○ |
| C-03 | 直接formatは禁止（compileError） | E-02 | ○ |
| C-04 | fmtValueでフォーマット出力 | E-03 | ○ |
| C-05 | toIpStringで文字列変換 | E-04 | ○ |
| C-06 | toAllocatedBytesでバイト列取得 | E-05 | ○ |
| C-07 | fromInternedでValue作成 | E-06 | ○ |
| C-08 | toInternでインデックス取得 | E-07 | ○ |
| C-09 | toBigIntで任意精度整数変換 | E-08 | ○ |
| C-10 | getFunctionで関数情報取得 | E-09 | ○ |
| C-11 | getVariableで変数情報取得 | E-10 | ○ |
| C-12 | getUnsignedIntでu64取得 | E-11 | ○ |
| C-13 | lazy_size/lazy_alignは遅延評価 | E-12 (272-278行目) | ○ |
| C-14 | 機能一覧にNo.45として定義 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Value構造体のip_indexフィールドを確認
- [ ] getUnsignedInt関数の戻り値型(?u64)を確認
- [ ] toBigInt関数のBigIntConst変換を確認
- [ ] lazy評価ロジックをgetUnsignedIntInnerで確認
