---
generated_at: 2026-02-01 18:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-ZIR

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/zig/Zir.zig` - ファイル先頭コメント（1-13行目）
- E-02: `lib/std/zig/Zir.zig` - Zir構造体定義（26-36行目）
- E-03: `lib/std/zig/Zir.zig` - instructionsフィールド（26行目）
- E-04: `lib/std/zig/Zir.zig` - string_bytesフィールド（32行目）
- E-05: `lib/std/zig/Zir.zig` - extraフィールド（36行目）
- E-06: `lib/std/zig/Zir.zig` - Header構造体（39-51行目）
- E-07: `lib/std/zig/Zir.zig` - ExtraIndex列挙型（53-62行目）
- E-08: `lib/std/zig/Zir.zig` - extraData関数（70-112行目）
- E-09: `lib/std/zig/Zir.zig` - NullTerminatedString型（114-117行目）
- E-10: `lib/std/zig/Zir.zig` - nullTerminatedString関数（120-123行目）
- E-11: `lib/std/zig/Zir.zig` - Inst.Tag列挙型（167行目以降）
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.47の定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ZIRはAstGenで生成されSemaで処理 | E-01 (3-5行目) | ○ |
| C-02 | ZIRはソースファイル全体で1インスタンス | E-01 (9-10行目参照) | ○ |
| C-03 | instructionsフィールドで命令リスト保持 | E-03 | ○ |
| C-04 | string_bytesフィールドで文字列データ保持 | E-04 | ○ |
| C-05 | extraフィールドで追加データ保持 | E-05 | ○ |
| C-06 | Header構造体でキャッシュ情報保持 | E-06 | ○ |
| C-07 | インデックス0は特殊ケース用に予約 | E-04 (32行目コメント) | ○ |
| C-08 | ExtraIndex列挙型で予約インデックス定義 | E-07 | ○ |
| C-09 | extraData関数で型ベースのデータ抽出 | E-08 | ○ |
| C-10 | NullTerminatedString型で文字列インデックス表現 | E-09 | ○ |
| C-11 | nullTerminatedString関数で文字列取得 | E-10 | ○ |
| C-12 | Inst.Tag列挙型で命令種別定義 | E-11 | ○ |
| C-13 | add命令が存在 | E-11 (169行目) | ○ |
| C-14 | param系命令が存在 | E-11 (241-249行目) | ○ |
| C-15 | 画面No.10,29,30と関連 | E-13 | ○ |
| C-16 | 機能一覧にNo.47として定義 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Zir構造体のフィールド定義を確認
- [ ] Header構造体のフィールドを確認
- [ ] extraData関数の型パラメータ処理を確認
- [ ] Inst.Tag列挙型の命令種別を確認
