---
generated_at: 2026-02-01 18:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-InternPool

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/InternPool.zig` - ファイル先頭コメント（1-3行目）
- E-02: `src/InternPool.zig` - localsフィールド（21行目）
- E-03: `src/InternPool.zig` - shardsフィールド（24行目）
- E-04: `src/InternPool.zig` - global_error_set（25行目）
- E-05: `src/InternPool.zig` - tid関連フィールド（28-34行目）
- E-06: `src/InternPool.zig` - src_hash_deps（36-41行目）
- E-07: `src/InternPool.zig` - nav_val_deps, nav_ty_deps（42-48行目）
- E-08: `src/InternPool.zig` - interned_deps（49-53行目）
- E-09: `src/InternPool.zig` - single_threaded定数（95行目）
- E-10: `src/InternPool.zig` - empty定数（97-120行目）
- E-11: `src/InternPool.zig` - TrackedInst構造体（122-214行目）
- E-12: `src/InternPool.zig` - MaybeLost構造体（134-155行目）
- E-13: `src/InternPool.zig` - Index構造体（157-213行目）
- E-14: `src/InternPool.zig` - trackZir関数（216-300行目）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.48の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InternPoolは型と値をインターン化 | E-01 | ○ |
| C-02 | localsフィールドでスレッドローカルストレージ管理 | E-02 | ○ |
| C-03 | shardsフィールドでハッシュテーブルシャード管理 | E-03 | ○ |
| C-04 | global_error_setでエラー名管理 | E-04 | ○ |
| C-05 | tid_width, tid_shift_*でスレッドID管理 | E-05 | ○ |
| C-06 | src_hash_depsでソースハッシュ依存追跡 | E-06 | ○ |
| C-07 | nav_val_deps, nav_ty_depsでNav依存追跡 | E-07 | ○ |
| C-08 | interned_depsでインターン値依存追跡 | E-08 | ○ |
| C-09 | single_threaded定数でシングルスレッドモード判定 | E-09 | ○ |
| C-10 | empty定数で空のInternPool初期化 | E-10 | ○ |
| C-11 | TrackedInstでZIR命令追跡 | E-11 | ○ |
| C-12 | MaybeLostで増分更新時のlost表現 | E-12 | ○ |
| C-13 | Index構造体でインデックス操作 | E-13 | ○ |
| C-14 | trackZir関数でZIR命令登録 | E-14 | ○ |
| C-15 | シャードは2のべき乗数 | E-03, E-14 | ○ |
| C-16 | 比較はO(1)（インデックス比較） | E-01, 設計原理 | ○ |
| C-17 | InternPool.zigは500KB超 | ファイルサイズ確認済み | ○ |
| C-18 | 機能一覧にNo.48として定義 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] InternPool構造体のフィールド定義を確認
- [ ] TrackedInst構造体の役割を確認
- [ ] trackZir関数のハッシュ・ロック処理を確認
- [ ] 依存関係追跡フィールドの用途を確認
