---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-test-obj.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 273-275行目 - test-objコマンド判定
- E-02: `src/main.zig` 1032-1034行目 - output_mode = .Obj設定
- E-03: `src/main.zig` 964-966行目 - is_test設定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 行6 - test-obj定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | test-objはテスト用オブジェクトファイルを生成する | E-01, E-04 | ○ |
| C-02 | ArgMode = .zig_test_objで処理 | E-01 | ○ |
| C-03 | output_mode = .Objが設定される | E-02 | ○ |
| C-04 | is_test = trueが設定される | E-03 | ○ |
| C-05 | 関連画面No.7が対応 | E-05 | ○ |
| C-06 | リンクや実行は行わない | E-02 | ○ |
| C-07 | testブロックを収集する | E-01, E-03 | ○ |
| C-08 | -ofmtオプションで形式指定可能 | E-01 | ○ |
| C-09 | -targetオプションでターゲット指定可能 | E-01 | ○ |
| C-10 | -Oオプションで最適化モード指定可能 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目

## 6) レビュアーチェックリスト（最小）
- [ ] .zig_test_objと.zig_testの違いが正しく記載されているか確認
- [ ] output_mode = .Objの設定箇所がドキュメントと一致するか確認
