---
generated_at: 2026-02-01 18:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-std.crypto

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**: 具体的なベンチマーク数値の根拠不足
  2. **ML-KEM(Kyber)の安定性**: ポスト量子暗号の実装状況確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/crypto.zig` - メインモジュール（427行）
- E-02: `lib/std/crypto/aes.zig` - AES実装（150行確認）
- E-03: `lib/std/crypto/aes_gcm.zig` - AES-GCM実装
- E-04: `lib/std/crypto/chacha20.zig` - ChaCha20実装
- E-05: `lib/std/crypto/sha2.zig` - SHA-2実装
- E-06: `lib/std/crypto/blake3.zig` - BLAKE3実装
- E-07: `lib/std/crypto/25519/ed25519.zig` - Ed25519実装
- E-08: `lib/std/crypto/ecdsa.zig` - ECDSA実装
- E-09: `lib/std/crypto/argon2.zig` - Argon2実装
- E-10: `lib/std/crypto/timing_safe.zig` - タイミングセーフ実装
- E-11: `lib/std/crypto/errors.zig` - エラー定義
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AEADカテゴリにAES-GCM、ChaCha20-Poly1305、AEGISを含む | E-01 (8-69行目) | ○ |
| C-02 | 認証関数としてHMAC、SipHash、CMACを提供 | E-01 (71-95行目) | ○ |
| C-03 | ハッシュ関数としてSHA-2、SHA-3、BLAKE2、BLAKE3を提供 | E-01 (134-149行目) | ○ |
| C-04 | デジタル署名としてEd25519、ECDSAを提供 | E-01 (197-202行目) | ○ |
| C-05 | パスワードハッシュとしてArgon2、bcrypt、scrypt、PBKDF2を提供 | E-01 (179-195行目) | ○ |
| C-06 | AESはハードウェアアクセラレーション対応 | E-02 (5-22行目) | ○ |
| C-07 | x86_64ではAES-NIを使用 | E-02 (9-10行目) | ○ |
| C-08 | aarch64ではARM Crypto Extensionsを使用 | E-02 (11-13行目) | ○ |
| C-09 | has_hardware_supportフラグで確認可能 | E-02 (20-22行目) | ○ |
| C-10 | サイドチャネル緩和レベルが4段階ある | E-01 (246-263行目) | ○ |
| C-11 | デフォルトの緩和レベルはmedium | E-01 (265行目) | ○ |
| C-12 | secureZero関数でメモリゼロ化 | E-01 (412-416行目) | ○ |
| C-13 | timing_safeモジュールで定数時間比較 | E-01 (5行目), E-10 | ○ |
| C-14 | X25519鍵交換をサポート | E-01 (113-115行目) | ○ |
| C-15 | ML-KEM（Kyber）KEMをサポート | E-01 (118-122行目) | ○ |
| C-16 | TLSモジュールを含む | E-01 (243行目) | ○ |
| C-17 | X.509証明書処理をサポート | E-01 (244行目) | ○ |
| C-18 | HKDFによる鍵導出 | E-01 (151-154行目) | ○ |
| C-19 | 楕円曲線としてP-256、P-384、secp256k1をサポート | E-01 (124-132行目) | ○ |
| C-20 | MD5、SHA-1は互換性のため存在 | E-01 (144-145行目) | ○ |
| C-21 | コーデック（ASN.1 DER等）をサポート | E-01 (239行目) | ○ |
| C-22 | 有限体演算をサポート | E-01 (236行目) | ○ |
| C-23 | 機能カテゴリが標準ライブラリ | E-12 | ○ |
| C-24 | パフォーマンスの具体的数値 | **根拠なし** | △ |
| C-25 | ML-KEMの安定性・成熟度 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスの具体的なベンチマーク数値
  - 候補：benchmark.zigの実行結果 / 外部ベンチマーク資料 / 公式ドキュメント
- ML-KEM実装の成熟度・NIST標準準拠状況
  - 候補：ml_kem.zigのコメント / Zigリリースノート / 公式ブログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認済み
- 1: 中リスク - パフォーマンス関連の主張は実測が必要
- 0: 低リスク - セキュリティ機能の存在はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AEAD実装が正しく列挙されているか確認
- [ ] ハードウェアアクセラレーションの条件分岐を確認
- [ ] サイドチャネル緩和レベルの説明が正確か確認
- [ ] ML-KEM実装の現在の状態を確認（実験的かどうか）
- [ ] 非推奨アルゴリズム（MD5、SHA-1）の警告が適切か確認
