---
generated_at: 2026-02-01 18:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-std.atomic

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/atomic.zig` - メインモジュール（503行確認）
- E-02: `lib/compiler_rt/atomics.zig` - コンパイラランタイム実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Value(T)でアトミック値をラップ | E-01 (2-115行目) | ○ |
| C-02 | rawフィールドで生の値にアクセス | E-01 (5-6行目) | ○ |
| C-03 | init関数で初期化 | E-01 (9-11行目) | ○ |
| C-04 | load関数でアトミックロード | E-01 (13-15行目) | ○ |
| C-05 | store関数でアトミックストア | E-01 (17-19行目) | ○ |
| C-06 | swap関数でアトミック交換 | E-01 (21-23行目) | ○ |
| C-07 | cmpxchgWeak関数で弱いCAS | E-01 (25-33行目) | ○ |
| C-08 | cmpxchgStrong関数で強いCAS | E-01 (35-43行目) | ○ |
| C-09 | fetchAdd/fetchSub関数 | E-01 (45-51行目) | ○ |
| C-10 | fetchMin/fetchMax関数 | E-01 (53-59行目) | ○ |
| C-11 | fetchAnd/fetchOr/fetchXor/fetchNand関数 | E-01 (61-75行目) | ○ |
| C-12 | rmw関数で汎用RMW操作 | E-01 (77-84行目) | ○ |
| C-13 | bitSet/bitReset/bitToggle関数 | E-01 (91-113行目) | ○ |
| C-14 | spinLoopHint関数 | E-01 (347-398行目) | ○ |
| C-15 | x86_64でpause命令使用 | E-01 (353-355行目) | ○ |
| C-16 | aarch64でisb命令使用 | E-01 (370-372行目) | ○ |
| C-17 | cacheLineForCpu関数 | E-01 (406-485行目) | ○ |
| C-18 | x86_64のキャッシュラインは128 | E-01 (418-425行目) | ○ |
| C-19 | cache_line定数 | E-01 (493行目) | ○ |
| C-20 | 機能カテゴリが標準ライブラリ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Value(T)の対応型を確認
- [ ] 各メモリオーダリングの説明が正確か確認
- [ ] キャッシュラインサイズの各アーキテクチャ対応を確認
- [ ] spinLoopHintの各アーキテクチャ対応を確認
