---
generated_at: 2026-02-01 18:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-std.posix

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/posix.zig` - メインモジュール（500行確認）
- E-02: `lib/std/posix/test.zig` - テストファイル
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クロスプラットフォーム抽象化レイヤー | E-01 (1-15行目) | ○ |
| C-02 | use_libcでlibc使用を判定 | E-01 (34-38行目) | ○ |
| C-03 | systemでlibc/linux/plan9を選択 | E-01 (45-63行目) | ○ |
| C-04 | 型エイリアス（AF, AT, E, O等）をエクスポート | E-01 (65-206行目) | ○ |
| C-05 | errno関数でerrnoを取得 | E-01 (283-289行目) | ○ |
| C-06 | close関数でFDをクローズ | E-01 (300-313行目) | ○ |
| C-07 | read関数でファイル読み取り | E-01 (405-448行目) | ○ |
| C-08 | readの上限はOS依存（Linux: 0x7ffff000） | E-01 (423-427行目) | ○ |
| C-09 | EINTRで自動リトライ | E-01 (428-431行目) | ○ |
| C-10 | openat関数でファイルオープン | E-01 (450-466行目) | ○ |
| C-11 | openatZでC文字列版 | E-01 (474-524行目) | ○ |
| C-12 | reboot関数（Linux固有） | E-01 (333-363行目) | ○ |
| C-13 | raise関数でシグナル送信 | E-01 (365-391行目) | ○ |
| C-14 | kill関数でプロセスにシグナル | E-01 (393-403行目) | ○ |
| C-15 | Windows非対応 | E-01 (コメント) | ○ |
| C-16 | WASIで一部制限 | E-01 (35-37行目) | ○ |
| C-17 | iovec構造体定義 | E-01 (207-215行目) | ○ |
| C-18 | 機能カテゴリが標準ライブラリ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 対応OS/プラットフォームの一覧を確認
- [ ] エラーコードマッピングが正確か確認
- [ ] read/writeの上限値が正確か確認
- [ ] EINTR自動リトライの範囲を確認
