---
generated_at: 2026-02-01 18:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-compiler_rt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/compiler_rt.zig` - エントリポイント（293行）
- E-02: `lib/compiler_rt/common.zig` - 共通定義
- E-03: `lib/compiler_rt/divti3.zig` - 128ビット除算
- E-04: `lib/compiler_rt/addf3.zig` - 浮動小数点加算
- E-05: `lib/compiler_rt/memcpy.zig` - メモリコピー
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | panic設定がtest_safetyに依存 | E-01 (7-10行目) | ○ |
| C-02 | comptimeブロックで各種ルーチンをインポート | E-01 (22行目) | ○ |
| C-03 | count0bits.zigでclz/ctz実装 | E-01 (24行目) | ○ |
| C-04 | parity.zigでパリティ計算 | E-01 (25行目) | ○ |
| C-05 | popcount.zigでポップカウント | E-01 (26行目) | ○ |
| C-06 | shift.zigでシフト演算 | E-01 (31行目) | ○ |
| C-07 | mulXi3.zigで大整数乗算 | E-01 (34行目) | ○ |
| C-08 | divti3.zigで128ビット除算 | E-01 (35行目) | ○ |
| C-09 | extendf.zigで浮動小数点精度拡張 | E-01 (58行目) | ○ |
| C-10 | truncf.zigで浮動小数点精度縮小 | E-01 (70行目) | ○ |
| C-11 | int_from_float.zigで整数変換 | E-01 (82行目) | ○ |
| C-12 | float_from_int.zigで浮動小数点変換 | E-01 (124行目) | ○ |
| C-13 | comparef.zigで浮動小数点比較 | E-01 (167行目) | ○ |
| C-14 | addf3.zigで浮動小数点加算 | E-01 (185行目) | ○ |
| C-15 | mulf3.zigで浮動小数点乗算 | E-01 (198行目) | ○ |
| C-16 | sin/cos/tan等の数学関数 | E-01 (233-250行目) | ○ |
| C-17 | memcpy/memset/memmove/memcmpのメモリ操作 | E-01 (276-280行目) | ○ |
| C-18 | stack_probe.zigでスタックプローブ | E-01 (269行目) | ○ |
| C-19 | atomics.zigでアトミック操作 | E-01 (268行目) | ○ |
| C-20 | ssp.zigでスタックプロテクタ | E-01 (281行目) | ○ |
| C-21 | Windows/UEFIで_fltusedをエクスポート | E-01 (287-289行目) | ○ |
| C-22 | 機能カテゴリがランタイムライブラリ | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 整数ルーチンの一覧を確認
- [ ] 浮動小数点変換関数の網羅性を確認
- [ ] 数学関数の実装精度を確認
- [ ] ターゲット固有の処理（arm.zig, hexagon.zig）を確認
