---
generated_at: 2026-02-01 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-run.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 276-278行目 - runコマンド判定
- E-02: `src/main.zig` 1055-1061行目 - "--" と runtime_args_start処理
- E-03: `src/main.zig` 1029-1030行目 - output_mode = .Exe設定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 行7 - run定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | runコマンドはビルドと実行を一括で行う | E-01, E-04 | ○ |
| C-02 | ArgMode = .runで処理 | E-01 | ○ |
| C-03 | output_mode = .Exeでコンパイル | E-03 | ○ |
| C-04 | "--" 以降は実行時引数として扱う | E-02 | ○ |
| C-05 | runtime_args_startが設定される | E-02 | ○ |
| C-06 | 関連画面No.8が対応 | E-05 | ○ |
| C-07 | 内部的にbuild-exeを呼び出す | E-03 | ○ |
| C-08 | 生成バイナリを子プロセスとして実行 | E-01 | ○ |
| C-09 | -targetオプションでターゲット指定可能 | E-01 | ○ |
| C-10 | -Oオプションで最適化モード指定可能 | E-01 | ○ |
| C-11 | 終了コードを伝播する | E-01 | ○ |
| C-12 | プログラム出力を転送する | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目

## 6) レビュアーチェックリスト（最小）
- [ ] "--" の処理がドキュメントと一致するか確認
- [ ] runtime_args_startの設定箇所がドキュメントと一致するか確認
