---
generated_at: 2026-02-01 18:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-ubsan_rt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/ubsan_rt.zig` - サニタイザランタイム全体（686行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceLocation構造体（file_name, line, col） | E-01 (6-10行目) | ○ |
| C-02 | TypeDescriptor構造体（kind, info, name） | E-01 (12-44行目) | ○ |
| C-03 | TypeDescriptor.Kindにinteger, float, unknown | E-01 (17-21行目) | ○ |
| C-04 | Value構造体とtd, handleフィールド | E-01 (48-51行目) | ○ |
| C-05 | getUnsignedInteger/getSignedIntegerメソッド | E-01 (52-81行目) | ○ |
| C-06 | getFloatメソッド | E-01 (83-100行目) | ○ |
| C-07 | OverflowData構造体（loc, td） | E-01 (137-140行目) | ○ |
| C-08 | overflowHandlerで加算/乗算/減算オーバーフロー処理 | E-01 (142-172行目) | ○ |
| C-09 | negationHandlerで否定オーバーフロー処理 | E-01 (181-189行目) | ○ |
| C-10 | divRemHandlerでゼロ除算と-1除算を検出 | E-01 (199-212行目) | ○ |
| C-11 | AlignmentAssumptionData構造体 | E-01 (214-218行目) | ○ |
| C-12 | alignmentAssumptionHandlerでアライメント違反検出 | E-01 (234-273行目) | ○ |
| C-13 | ShiftOobData構造体（lhs_type, rhs_type） | E-01 (275-279行目) | ○ |
| C-14 | shiftOobで負のシフト量とサイズ超過を検出 | E-01 (289-320行目) | ○ |
| C-15 | OutOfBoundsData構造体（array_type, index_type） | E-01 (322-326行目) | ○ |
| C-16 | outOfBoundsで配列境界外アクセス検出 | E-01 (335-344行目) | ○ |
| C-17 | pointerOverflowでnullポインタ操作検出 | E-01 (358-402行目) | ○ |
| C-18 | TypeMismatchData構造体とkind enum | E-01 (404-438行目) | ○ |
| C-19 | typeMismatchでnull/アライメント違反検出 | E-01 (447-473行目) | ○ |
| C-20 | builtinUnreachableで到達不能コード検出 | E-01 (479-481行目) | ○ |
| C-21 | missingReturnで返り値なし検出 | E-01 (483-485行目) | ○ |
| C-22 | exportHandler/exportHandlerWithAbortでシンボルエクスポート | E-01 (617-643行目) | ○ |
| C-23 | can_build_ubsanでpowerpc/riscv64を除外 | E-01 (645-650行目) | ○ |
| C-24 | comptimeブロックで全ハンドラを登録 | E-01 (652-685行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされるUBSanチェックの一覧を確認
- [ ] 各ハンドラのpanicメッセージが適切か確認
- [ ] weak linkageの動作を確認
- [ ] abort版ハンドラの必要性を確認
- [ ] 未実装ハンドラ（dynamic_type_cache_miss等）の影響を確認
