---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-fuzzer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **テストフレームワークとの連携詳細**：具体的な呼び出しインターフェースの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/fuzzer.zig` - ファジング機能のメイン実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fuzzerはカバレッジガイド付きファジングを提供する | E-01 (587-631行目: export関数群) | ○ |
| C-02 | SanitizerCoverage計装によるコードカバレッジ追跡 | E-01 (653-730行目: __sanitizer_cov_* export関数) | ○ |
| C-03 | 入力データの変異による新規テストケース生成 | E-01 (748-1302行目: Mutation列挙型と処理) | ○ |
| C-04 | 新しいPCを発見した入力の保存とコーパス管理 | E-01 (547-583行目: cycle関数) | ○ |
| C-05 | メモリマップドファイルによる入力データの永続化 | E-01 (1306-1451行目: MemoryMappedList構造体) | ○ |
| C-06 | 入力の最小化処理 | E-01 (488-507行目: minimizeInput関数) | ○ |
| C-07 | ELFおよびMach-Oオブジェクト形式をサポート | E-01 (180-184行目: section prefix定義) | ○ |
| C-08 | キャッシュディレクトリへのファイル出力 | E-01 (167-175行目: Executable.init) | ○ |
| C-09 | 共有カバレッジファイルの管理 | E-01 (83-165行目: getCoverageFile関数) | ○ |
| C-10 | 成功したミューテーションの選択確率上昇 | E-01 (572-573行目: mutations.appendNTimes) | ○ |
| C-11 | 空入力の常時存在ルール | E-01 (441-443行目: addInput(&.{})) | ○ |
| C-12 | 排他ロックによる複数プロセスの競合防止 | E-01 (413-419行目: lock = .exclusive) | ○ |
| C-13 | デバッグビルドとリリースビルドでアロケータを切り替え | E-01 (45-49行目: gpa定義) | ○ |
| C-14 | 非決定性テストの検出と警告 | E-01 (563-567行目: non-deterministic警告) | ○ |
| C-15 | テスト実行画面との関連 | E-03 (61行目: fuzzer補助機能) | ○ |
| C-16 | ランタイムカテゴリに属する | E-02 (62行目: ランタイム,fuzzer) | ○ |
| C-17 | lib/fuzzer.zigに実装 | E-02 (62行目: lib/fuzzer.zig) | ○ |
| C-18 | テストフレームワークからの具体的な呼び出しフロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テストフレームワーク（testing.zig）からfuzzerへの具体的な呼び出しインターフェースの詳細
  - 候補：`lib/std/testing.zig` / `lib/std/Build.zig` / テストランナー実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる主張がほとんど
- 1: 中リスク - テストフレームワーク連携の詳細は追加調査が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] ファジング機能の入出力仕様が実際のコードと一致しているか確認
- [ ] ミューテーション種別の網羅性を確認
- [ ] パフォーマンス要件の妥当性を確認
- [ ] テストフレームワークとの連携部分の詳細を補完
