---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-libcサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libs/glibc.zig` - glibcサポートの実装
- E-02: `src/libs/musl.zig` - muslサポートの実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | glibc、musl、mingw等の複数libc実装をサポート | E-01, E-02, E-03 | ○ |
| C-02 | CRTファイル（crt1.o、Scrt1.o等）のビルド | E-01 (166-239行目), E-02 (21-87行目) | ○ |
| C-03 | abilistファイルからシンボルバージョニング処理 | E-01 (60-157行目: loadMetaData) | ○ |
| C-04 | 共有ライブラリスタブの生成 | E-01 (660-1137行目: buildSharedObjects) | ○ |
| C-05 | libc_nonshared.aのビルド | E-01 (240-356行目) | ○ |
| C-06 | バージョン2.34以降でpthread、dl等が削除 | E-01 (43-46行目: removed_in定義) | ○ |
| C-07 | PIE対応のScrt1.o選択 | E-01 (237行目: 条件分岐) | ○ |
| C-08 | muslのアーキテクチャ固有オーバーライド | E-02 (118-157行目: override_path処理) | ○ |
| C-09 | time32互換アーキテクチャリスト | E-02 (304-314行目: time32_compat_arch_list) | ○ |
| C-10 | LLVMバックエンドが必要 | E-01 (167-168行目: build_options.have_llvm) | ○ |
| C-11 | グローバルキャッシュへの保存 | E-01 (678-688行目: cache設定) | ○ |
| C-12 | Lib構造体によるライブラリ情報管理 | E-01 (18-22行目) | ○ |
| C-13 | ABI構造体によるシンボル情報管理 | E-01 (24-35行目) | ○ |
| C-14 | InvalidTargetGLibCVersionエラー | E-01 (742-744行目) | ○ |
| C-15 | Cコンパイラ画面との関連 | E-04 (29行目: libcサポート補助機能) | ○ |
| C-16 | C言語互換カテゴリに属する | E-03 (63行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サポートするglibcバージョン範囲の確認
- [ ] 各アーキテクチャ固有処理の網羅性確認
- [ ] abilistファイル形式の詳細確認
