---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-libcxx

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libs/libcxx.zig` - libc++/libc++abiビルドの実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libc++およびlibc++abiの静的ライブラリビルド | E-01 (111-302, 304-500行目) | ○ |
| C-02 | WASIではfilesystem関連ファイル除外 | E-01 (200-201行目) | ○ |
| C-03 | Windowsでのみwin32サポートファイル含む | E-01 (202-203行目) | ○ |
| C-04 | シングルスレッドモードでスレッドファイル除外 | E-01 (191-194行目) | ○ |
| C-05 | WASIで例外処理無効化 | E-01 (215-217行目: -fno-exceptions) | ○ |
| C-06 | LLVMなしでビルドされたZigではエラー | E-01 (112-113行目) | ○ |
| C-07 | C++23標準でコンパイル | E-01 (225行目: -std=c++23) | ○ |
| C-08 | int128_builtins.cpp除外 | E-01 (52-54行目: コメント) | ○ |
| C-09 | 関数セクション分離 | E-01 (268行目: function_sections = true) | ○ |
| C-10 | シンボル可視性制御 | E-01 (219-220行目: -fvisibility=hidden) | ○ |
| C-11 | libcxxabi_filesリスト定義 | E-01 (11-36行目) | ○ |
| C-12 | libcxx_base_filesリスト定義 | E-01 (38-90行目) | ○ |
| C-13 | libcxx_thread_filesリスト定義 | E-01 (92-103行目) | ○ |
| C-14 | C++コンパイラ画面との関連 | E-03 (31行目: libcxx補助機能) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] C++標準バージョンの妥当性確認
- [ ] プラットフォーム固有処理の網羅性確認
- [ ] 除外されるファイルの影響確認
