---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-libunwind

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libs/libunwind.zig` - libunwindビルドの実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libunwindの静的ライブラリビルド | E-01 (17-192行目: buildStaticLib) | ○ |
| C-02 | 32ビットx86 Windowsではアンワインドテーブルなし | E-01 (32-33行目) | ○ |
| C-03 | ARM hardfloatでCOMPILER_RT_ARMHF_TARGET定義 | E-01 (126-128行目) | ○ |
| C-04 | シングルスレッドで_LIBUNWIND_HAS_NO_THREADS定義 | E-01 (123-125行目) | ○ |
| C-05 | _LIBUNWIND_IS_NATIVE_ONLY常時定義 | E-01 (118行目) | ○ |
| C-06 | LLVMなしでビルドされたZigではエラー | E-01 (18-20行目) | ○ |
| C-07 | unwind_src_listのファイルリスト | E-01 (194-205行目) | ○ |
| C-08 | Cファイルは-std=c99と-fexceptions | E-01 (94-98行目) | ○ |
| C-09 | C++ファイルは-fno-exceptionsと-fno-rtti | E-01 (100-103行目) | ○ |
| C-10 | 関数セクション分離 | E-01 (158行目: function_sections = true) | ○ |
| C-11 | シンボル可視性制御 | E-01 (111-113行目: -fvisibility=hidden) | ○ |
| C-12 | 非実行可能スタック | E-01 (110行目: --noexecstack) | ○ |
| C-13 | C言語互換カテゴリに属する | E-02 (65行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] アンワインドテーブル設定の妥当性確認
- [ ] プラットフォーム固有処理の網羅性確認
- [ ] アセンブリファイルのアーキテクチャ対応確認
