---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-docgen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/docgen.zig` - docgenツールのメイン実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートファイルからHTMLドキュメントを生成 | E-01 (31-87行目: main関数) | ○ |
| C-02 | 入力ファイルサイズ上限10MB | E-01 (16行目: max_doc_file_size) | ○ |
| C-03 | Token構造体の定義 | E-01 (89-103行目) | ○ |
| C-04 | Tokenizer構造体の定義 | E-01 (105-243行目) | ○ |
| C-05 | Node共用体の定義 | E-01 (316-327行目) | ○ |
| C-06 | Toc構造体の定義 | E-01 (329-333行目) | ○ |
| C-07 | 引数: input, output, --code-dir | E-01 (20-29行目: usage定義) | ○ |
| C-08 | header_open/header_closeタグのサポート | E-01 (382-451行目) | ○ |
| C-09 | 重複URL禁止ルール | E-01 (419-423行目) | ○ |
| C-10 | parseErrorによるエラー報告 | E-01 (245-267行目) | ○ |
| C-11 | urlize関数によるURL生成 | E-01 (411行目) | ○ |
| C-12 | ツールカテゴリに属する | E-02 (66行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 対応するテンプレートタグの網羅性確認
- [ ] HTML出力の妥当性確認
- [ ] エラーハンドリングの網羅性確認
