---
generated_at: 2026-02-01 11:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-dump-zir

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` - cmdDumpZir関数の実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デバッグビルド専用機能 | E-01 (6529行目: dev.check(.dump_zir_command)) | ○ |
| C-02 | cache_fileを引数として受け取る | E-01 (6533行目: args[0]) | ○ |
| C-03 | ファイルオープンとエラーハンドリング | E-01 (6535-6536行目) | ○ |
| C-04 | Zcu.loadZirCacheでZIR読み込み | E-01 (6540行目) | ○ |
| C-05 | instruction_bytes計算式 | E-01 (6544-6547行目) | ○ |
| C-06 | extra_bytes計算式 | E-01 (6548行目) | ○ |
| C-07 | total_bytes計算式 | E-01 (6549-6550行目) | ○ |
| C-08 | 統計ヘッダー出力 | E-01 (6552-6563行目) | ○ |
| C-09 | print_zir.renderAsTextでテキスト出力 | E-01 (6567行目) | ○ |
| C-10 | ストリーミング出力 | E-01 (6541行目: writerStreaming) | ○ |
| C-11 | Bi単位でのサイズ表示 | E-01 (6553-6556行目: {Bi}フォーマット) | ○ |
| C-12 | デバッグカテゴリに属する | E-02 (71行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] デバッグビルド制限の妥当性確認
- [ ] バイト計算式の正確性確認
- [ ] 出力フォーマットの可読性確認
