---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-detect-cpu

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` - 381-382行目（detect-cpuコマンドディスパッチ）
- E-02: `src/main.zig` - 6351-6398行目（cmdDetectCpu関数）
- E-03: `src/main.zig` - 6354-6363行目（ヘルプメッセージ定義）
- E-04: `src/main.zig` - 6386-6398行目（CPU検出処理分岐）
- E-05: `src/main.zig` - 6401-6462行目（detectNativeCpuWithLLVM関数）
- E-06: `src/main.zig` - 6464-6482行目（printCpu関数）
- E-07: `src/main.zig` - 121-130行目（debug_usage定義、detect-cpu記載）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 51行目
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 72行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | detect-cpuはデバッグ拡張コマンドである | E-07 | ○ |
| C-02 | ホストCPUの名前と機能セットを標準出力に表示する | E-02, E-06 | ○ |
| C-03 | --llvmオプションでLLVM APIを使用できる | E-03, E-04 | ○ |
| C-04 | -h/--helpオプションでヘルプを表示 | E-02, E-03 | ○ |
| C-05 | LLVMビルドが必要な場合にエラーを返す | E-04 (6387-6388行目) | ○ |
| C-06 | detectNativeCpuWithLLVM関数でCPU構造体を構築 | E-05 | ○ |
| C-07 | std.zig.resolveTargetQueryOrFatalでホストターゲット取得 | E-04 (6396行目) | ○ |
| C-08 | printCpu関数でCPU情報を出力 | E-06 | ○ |
| C-09 | CPU名はLLVM名で出力される | E-06 (6468-6470行目) | ○ |
| C-10 | 機能フラグは+/-プレフィックスで出力 | E-06 (6477行目) | ○ |
| C-11 | LLVM APIはGetHostCPUName/GetHostCPUFeaturesを使用 | E-04 (6391-6392行目) | ○ |
| C-12 | 画面No.31 CPU検出画面と関連 | E-08 | ○ |
| C-13 | 機能一覧No.71として登録されている | E-09 | ○ |
| C-14 | コマンドライン引数を解析する | E-02 (6367-6384行目) | ○ |
| C-15 | 不正な引数でfatalエラー | E-02 (6378行目) | ○ |
| C-16 | LLVM名が定義されている機能のみ表示 | E-06 (6474行目) | ○ |
| C-17 | build_options.enable_debug_extensionsで制御 | E-01 (383行目) | ○ |
| C-18 | パフォーマンスは数ミリ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**
  - 具体的な性能測定値やベンチマーク結果が存在しない
  - 候補：実際の実行時間計測 / パフォーマンステストの追加

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）

- [ ] cmdDetectCpu関数の引数解析ロジックが正確に記載されているか確認
- [ ] LLVM API呼び出しの前提条件（have_llvm）が正しく記載されているか確認
- [ ] 出力形式のサンプルが実際の出力と一致するか確認
- [ ] enable_debug_extensionsの条件分岐が正しく記載されているか確認
