---
generated_at: 2026-02-01 12:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-llvm-ints

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` - 387-388行目（llvm-intsコマンドディスパッチ）
- E-02: `src/main.zig` - 6484-6525行目（cmdDumpLlvmInts関数全体）
- E-03: `src/main.zig` - 6490行目（dev.check呼び出し）
- E-04: `src/main.zig` - 6494-6495行目（LLVMビルドチェック）
- E-05: `src/main.zig` - 6497行目（ターゲットトリプル取得）
- E-06: `src/main.zig` - 6501-6503行目（ターゲット初期化）
- E-07: `src/main.zig` - 6505-6510行目（ターゲット取得）
- E-08: `src/main.zig` - 6511-6513行目（TargetMachine、DataLayout、Context作成）
- E-09: `src/main.zig` - 6517-6521行目（整数型ループとアラインメント出力）
- E-10: `src/main.zig` - 121-130行目（debug_usage定義）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 52行目
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 73行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | llvm-intsはデバッグ拡張コマンドである | E-10 | ○ |
| C-02 | LLVMのABIアラインメント値を表示する | E-09 | ○ |
| C-03 | ターゲットトリプルを引数として受け取る | E-05 | ○ |
| C-04 | LLVMビルドが必要である | E-04 | ○ |
| C-05 | dev.checkでデバッグモードを確認する | E-03 | ○ |
| C-06 | aarch64とx86のターゲットを初期化する | E-06 | ○ |
| C-07 | Target.getFromTripleでターゲット取得 | E-07 | ○ |
| C-08 | TargetMachine.createでターゲットマシン作成 | E-08 | ○ |
| C-09 | 整数型は1,8,16,32,64,128,256ビット | E-09 | ○ |
| C-10 | context.intTypeで整数型を作成 | E-09 | ○ |
| C-11 | abiAlignmentOfTypeでアラインメント取得 | E-09 | ○ |
| C-12 | 画面No.32 LLVM整数ダンプ画面と関連 | E-11 | ○ |
| C-13 | 機能一覧No.72として登録されている | E-12 | ○ |
| C-14 | 無効なトリプルでパニック | E-07 (6508行目) | ○ |
| C-15 | enable_debug_extensionsで制御 | E-01 | ○ |
| C-16 | 出力形式はLLVMABIAlignmentOfType(iN)==M | E-09 (6520行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主要な機能仕様がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] cmdDumpLlvmInts関数のLLVM API呼び出し順序が正確に記載されているか確認
- [ ] 対象整数型のビット幅リスト（1,8,16,32,64,128,256）が正しいか確認
- [ ] 出力形式のサンプルが実際の出力と一致するか確認
- [ ] ターゲット初期化のアーキテクチャ（aarch64, x86）が正しいか確認
