---
generated_at: 2026-02-01 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-Tracy統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tracy.zig` - 5行目（enable定数定義）
- E-02: `src/tracy.zig` - 6行目（enable_allocation定数定義）
- E-03: `src/tracy.zig` - 7行目（enable_callstack定数定義）
- E-04: `src/tracy.zig` - 8行目（callstack_depth定数定義）
- E-05: `src/tracy.zig` - 10-33行目（___tracy_c_zone_context構造体）
- E-06: `src/tracy.zig` - 35-59行目（ダミーCtx構造体）
- E-07: `src/tracy.zig` - 61-79行目（trace関数）
- E-08: `src/tracy.zig` - 81-99行目（traceNamed関数）
- E-09: `src/tracy.zig` - 101-103行目（tracyAllocator関数）
- E-10: `src/tracy.zig` - 105-196行目（TracyAllocator型）
- E-11: `src/tracy.zig` - 129-144行目（allocFn）
- E-12: `src/tracy.zig` - 141行目（messageColor "allocation failed"）
- E-13: `src/tracy.zig` - 177行目（messageColor "reallocation failed"）
- E-14: `src/tracy.zig` - 199-218行目（message関数群）
- E-15: `src/tracy.zig` - 220-251行目（frameMark関数群）
- E-16: `src/tracy.zig` - 296-322行目（extern関数宣言）
- E-17: `src/main.zig` - 24行目（tracy.zigのimport）
- E-18: `src/main.zig` - 207-209行目（tracyAllocatorの使用）
- E-19: `src/Compilation.zig` - 22-23行目（tracy import and trace alias）
- E-20: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 58行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tracy統合はプロファイリング機能を提供する | E-07, E-09, E-15 | ○ |
| C-02 | build_options.enable_tracyで有効化を制御 | E-01 | ○ |
| C-03 | enable_allocation、enable_callstackオプションがある | E-02, E-03 | ○ |
| C-04 | デフォルトのコールスタック深度は10 | E-04 | ○ |
| C-05 | Tracy無効時はダミーCtxが使用される | E-06 | ○ |
| C-06 | ダミーCtxのメソッドは何もしない | E-06 | ○ |
| C-07 | trace関数でゾーンを開始する | E-07 | ○ |
| C-08 | traceNamed関数で名前付きゾーンを開始 | E-08 | ○ |
| C-09 | tracyAllocatorでアロケータをラップ | E-09 | ○ |
| C-10 | TracyAllocatorはalloc/resize/remap/freeをフック | E-10 | ○ |
| C-11 | アロケーション失敗時に赤色メッセージ出力 | E-12 | ○ |
| C-12 | リアロケーション失敗時に赤色メッセージ出力 | E-13 | ○ |
| C-13 | message/messageColor関数でメッセージ出力 | E-14 | ○ |
| C-14 | frameMark/frameMarkNamed関数でフレームマーク | E-15 | ○ |
| C-15 | extern宣言でC APIを呼び出す | E-16 | ○ |
| C-16 | テストビルド時はTracyを無効化 | E-01 (builtin.is_test) | ○ |
| C-17 | main.zigでtracyAllocatorを使用している | E-18 | ○ |
| C-18 | Compilation.zigでtraceを使用している | E-19 | ○ |
| C-19 | テスト実行画面（画面No.6）と関連 | E-20 | ○ |
| C-20 | Ctxはend/addText/setName/setColor/setValueメソッドを持つ | E-05, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主要な機能仕様がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] enable/enable_allocation/enable_callstackの条件分岐が正確に記載されているか確認
- [ ] Ctx構造体のメソッド一覧が網羅されているか確認
- [ ] TracyAllocatorの4つのコールバック（alloc/resize/remap/free）が正しく記載されているか確認
- [ ] extern関数宣言のリストが網羅されているか確認
