---
generated_at: 2026-02-01 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：74-インクリメンタルコンパイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **安定化スケジュール**：0.14.0での安定化は推測

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilation/Config.zig` - 53行目（incremental: boolフィールド）
- E-02: `src/Compilation/Config.zig` - 110行目（Options.incremental: bool = false）
- E-03: `src/Compilation/Config.zig` - 448-454行目（use_new_linker連動）
- E-04: `src/Compilation/Config.zig` - 569行目（incremental設定の反映）
- E-05: `src/main.zig` - 429行目（ヘルプでの-fincremental記載）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 57行目
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 75行目
- E-08: `src/Compilation/Config.zig` - 134行目（LldCannotIncrementallyLinkエラー）
- E-09: `src/Compilation/Config.zig` - 156行目（NewLinkerIncompatibleWithLldエラー）
- E-10: `src/link.zig` - リンカ統合（incremental関連）
- E-11: `src/IncrementalDebugServer.zig` - デバッグサーバー存在確認

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -fincrementalオプションで有効化される | E-02, E-05 | ○ |
| C-02 | incremental: boolフィールドが存在する | E-01 | ○ |
| C-03 | デフォルトはfalse | E-02 | ○ |
| C-04 | incremental有効時はuse_new_linkerも連動して有効 | E-03 | ○ |
| C-05 | incremental設定がConfigに反映される | E-04 | ○ |
| C-06 | 画面No.3 実行ファイルビルド画面と関連 | E-06 | ○ |
| C-07 | 機能一覧No.74として登録されている | E-07 | ○ |
| C-08 | LLDはインクリメンタルリンキングをサポートしない | E-08 | ○ |
| C-09 | 新リンカとLLDは同時に使用できない | E-09 | ○ |
| C-10 | IncrementalDebugServerが存在する | E-11 | ○ |
| C-11 | link.zigにインクリメンタル関連処理がある | E-10 | ○ |
| C-12 | ヘルプに-fincremental/-fno-incrementalの説明がある | E-05 | ○ |
| C-13 | キャッシュシステムを使用する | E-02 (キャッシュモードとの関連) | ○ |
| C-14 | 変更検出を行う | E-10 (link.zigの処理) | ○ |
| C-15 | 差分コンパイルを実行する | E-10, E-11 | ○ |
| C-16 | 差分リンクを実行する | E-03, E-10 | ○ |
| C-17 | 80%以上の時間短縮が期待される | **根拠なし** | △ |
| C-18 | 0.14.0以降で安定化を目指している | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス数値の根拠**
  - 80%以上の時間短縮は一般的な期待値であり、具体的なベンチマーク結果は確認できていない
  - 候補：ベンチマーク結果の追加 / 実測値の記録

- **安定化スケジュール**
  - 0.14.0での安定化はRoadmapやIssueから推測されるが、公式な記載は確認できていない
  - 候補：公式ドキュメント / Roadmap / Issue tracker

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 1: 中リスク - パフォーマンス期待値と安定化スケジュールは推測

## 6) レビュアーチェックリスト（最小）

- [ ] Config.zigのincremental設定の解決ロジックが正確に記載されているか確認
- [ ] use_new_linkerとの連動条件が正しく記載されているか確認
- [ ] LLD非互換のエラー条件が正確か確認
- [ ] パフォーマンス期待値を公式な数値に更新または削除
- [ ] 安定化スケジュールを公式情報に基づいて更新または削除
