---
generated_at: 2026-02-01 16:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - メインエントリポイント、コマンドパーサー（行77-130: normal_usage定数）
- E-02: `src/main.zig` - コマンドディスパッチ処理（行259-392: mainArgs関数）
- E-03: `src/main.zig` - ビルドオプション使用方法（行395-500: usage_build_generic定数）
- E-04: `src/fmt.zig` - フォーマットコマンド実装
- E-05: `src/print_env.zig` - 環境情報出力コマンド実装
- E-06: `src/print_targets.zig` - ターゲット一覧コマンド実装
- E-07: `README.md` - プロジェクト概要とインストール手順

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ヘルプ画面（zig help）が存在する | E-01, E-02 | ○ |
| C-02 | プロジェクトビルド画面（zig build）が存在する | E-01, E-02 | ○ |
| C-03 | 実行ファイルビルド画面（zig build-exe）が存在する | E-01, E-02, E-03 | ○ |
| C-04 | ライブラリビルド画面（zig build-lib）が存在する | E-01, E-02, E-03 | ○ |
| C-05 | オブジェクトビルド画面（zig build-obj）が存在する | E-01, E-02, E-03 | ○ |
| C-06 | テスト実行画面（zig test）が存在する | E-01, E-02 | ○ |
| C-07 | テストオブジェクト画面（zig test-obj）が存在する | E-01, E-02 | ○ |
| C-08 | 即時実行画面（zig run）が存在する | E-01, E-02 | ○ |
| C-09 | AST検査画面（zig ast-check）が存在する | E-01, E-02 | ○ |
| C-10 | フォーマット画面（zig fmt）が存在する | E-01, E-02, E-04 | ○ |
| C-11 | バグレポート最小化画面（zig reduce）が存在する | E-01, E-02 | ○ |
| C-12 | C言語変換画面（zig translate-c）が存在する | E-01, E-02 | ○ |
| C-13 | アーカイバ画面（zig ar）が存在する | E-01, E-02 | ○ |
| C-14 | Cコンパイラ画面（zig cc）が存在する | E-01, E-02 | ○ |
| C-15 | C++コンパイラ画面（zig c++）が存在する | E-01, E-02 | ○ |
| C-16 | DLLツール画面（zig dlltool）が存在する | E-01, E-02 | ○ |
| C-17 | Libツール画面（zig lib）が存在する | E-01, E-02 | ○ |
| C-18 | Ranlibツール画面（zig ranlib）が存在する | E-01, E-02 | ○ |
| C-19 | Objcopyツール画面（zig objcopy）が存在する | E-01, E-02 | ○ |
| C-20 | RCツール画面（zig rc）が存在する | E-01, E-02 | ○ |
| C-21 | 環境情報画面（zig env）が存在する | E-01, E-02, E-05 | ○ |
| C-22 | 標準ライブラリドキュメント画面（zig std）が存在する | E-01, E-02 | ○ |
| C-23 | libc情報画面（zig libc）が存在する | E-01, E-02 | ○ |
| C-24 | ターゲット一覧画面（zig targets）が存在する | E-01, E-02, E-06 | ○ |
| C-25 | バージョン画面（zig version）が存在する | E-01, E-02 | ○ |
| C-26 | Zen画面（zig zen）が存在する | E-01, E-02 | ○ |
| C-27 | パッケージ取得画面（zig fetch）が存在する | E-01, E-02 | ○ |
| C-28 | プロジェクト初期化画面（zig init）が存在する | E-01, E-02 | ○ |
| C-29 | 変更リスト画面（zig changelist）がデバッグモードで存在する | E-01, E-02 | ○ |
| C-30 | ZIRダンプ画面（zig dump-zir）がデバッグモードで存在する | E-01, E-02 | ○ |
| C-31 | CPU検出画面（zig detect-cpu）がデバッグモードで存在する | E-01, E-02 | ○ |
| C-32 | LLVM整数ダンプ画面（zig llvm-ints）がデバッグモードで存在する | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張について、ソースコード（src/main.zig）から直接的な根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接抽出されており、信頼性が高い
- 注意点:
  - デバッグコマンド（changelist, dump-zir, detect-cpu, llvm-ints）はデバッグビルドでのみ利用可能
  - 一部のコマンド（cc, c++, translate-c等）はLLVM拡張機能が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の全32コマンドが実際のソースコードと一致しているか確認
- [ ] デバッグコマンドがデバッグモード限定であることが正しく記載されているか確認
- [ ] 画面遷移図のコマンド間の関係性が論理的に正しいか確認
- [ ] カテゴリ分類が適切か確認（ビルド、テスト、実行、コード品質、変換、互換ツール、情報、パッケージ管理、デバッグ）
