# 画面遷移図

## 概要

Zigコンパイラはコマンドラインインターフェース（CLI）ツールであり、GUIの画面は存在しません。
本ドキュメントでは、CLIコマンドの構造と遷移関係を画面遷移図として表現します。

## 画面遷移図（Mermaid形式）

```mermaid
flowchart TD
    subgraph Entry["エントリポイント"]
        ZIG["zig コマンド"]
    end

    subgraph Help["ヘルプ"]
        HELP["ヘルプ画面<br/>zig help"]
    end

    subgraph Build["ビルドコマンド"]
        BUILD["プロジェクトビルド画面<br/>zig build"]
        BUILD_EXE["実行ファイルビルド画面<br/>zig build-exe"]
        BUILD_LIB["ライブラリビルド画面<br/>zig build-lib"]
        BUILD_OBJ["オブジェクトビルド画面<br/>zig build-obj"]
    end

    subgraph Test["テストコマンド"]
        TEST["テスト実行画面<br/>zig test"]
        TEST_OBJ["テストオブジェクト画面<br/>zig test-obj"]
    end

    subgraph Run["実行コマンド"]
        RUN["即時実行画面<br/>zig run"]
    end

    subgraph Quality["コード品質コマンド"]
        AST_CHECK["AST検査画面<br/>zig ast-check"]
        FMT["フォーマット画面<br/>zig fmt"]
        REDUCE["バグレポート最小化画面<br/>zig reduce"]
    end

    subgraph Convert["変換コマンド"]
        TRANSLATE_C["C言語変換画面<br/>zig translate-c"]
    end

    subgraph Compat["互換ツールコマンド"]
        AR["アーカイバ画面<br/>zig ar"]
        CC["Cコンパイラ画面<br/>zig cc"]
        CPP["C++コンパイラ画面<br/>zig c++"]
        DLLTOOL["DLLツール画面<br/>zig dlltool"]
        LIB["Libツール画面<br/>zig lib"]
        RANLIB["Ranlibツール画面<br/>zig ranlib"]
        OBJCOPY["Objcopyツール画面<br/>zig objcopy"]
        RC["RCツール画面<br/>zig rc"]
    end

    subgraph Info["情報コマンド"]
        ENV["環境情報画面<br/>zig env"]
        STD["標準ライブラリドキュメント画面<br/>zig std"]
        LIBC["libc情報画面<br/>zig libc"]
        TARGETS["ターゲット一覧画面<br/>zig targets"]
        VERSION["バージョン画面<br/>zig version"]
        ZEN["Zen画面<br/>zig zen"]
    end

    subgraph Package["パッケージ管理コマンド"]
        FETCH["パッケージ取得画面<br/>zig fetch"]
        INIT["プロジェクト初期化画面<br/>zig init"]
    end

    subgraph Debug["デバッグコマンド（デバッグモード限定）"]
        CHANGELIST["変更リスト画面<br/>zig changelist"]
        DUMP_ZIR["ZIRダンプ画面<br/>zig dump-zir"]
        DETECT_CPU["CPU検出画面<br/>zig detect-cpu"]
        LLVM_INTS["LLVM整数ダンプ画面<br/>zig llvm-ints"]
    end

    %% メインからの遷移
    ZIG --> HELP
    ZIG --> BUILD
    ZIG --> BUILD_EXE
    ZIG --> BUILD_LIB
    ZIG --> BUILD_OBJ
    ZIG --> TEST
    ZIG --> TEST_OBJ
    ZIG --> RUN
    ZIG --> AST_CHECK
    ZIG --> FMT
    ZIG --> REDUCE
    ZIG --> TRANSLATE_C
    ZIG --> AR
    ZIG --> CC
    ZIG --> CPP
    ZIG --> DLLTOOL
    ZIG --> LIB
    ZIG --> RANLIB
    ZIG --> OBJCOPY
    ZIG --> RC
    ZIG --> ENV
    ZIG --> STD
    ZIG --> LIBC
    ZIG --> TARGETS
    ZIG --> VERSION
    ZIG --> ZEN
    ZIG --> FETCH
    ZIG --> INIT
    ZIG --> CHANGELIST
    ZIG --> DUMP_ZIR
    ZIG --> DETECT_CPU
    ZIG --> LLVM_INTS

    %% ビルド系コマンド間の関係
    BUILD_EXE -.->|生成物を使用| RUN
    BUILD_LIB -.->|ライブラリをリンク| BUILD_EXE
    BUILD_OBJ -.->|オブジェクトファイルを入力| BUILD_EXE
    BUILD_OBJ -.->|オブジェクトファイルを入力| BUILD_LIB

    %% テスト系の関係
    TEST_OBJ -.->|テストオブジェクト生成| TEST

    %% 互換ツール間の関係
    CC -.->|オブジェクト生成| AR
    CPP -.->|オブジェクト生成| AR

    %% パッケージ管理の関係
    INIT -.->|パッケージ依存追加後| FETCH
    FETCH -.->|依存解決後| BUILD

    %% スタイル
    classDef entryStyle fill:#e1f5fe,stroke:#01579b,stroke-width:2px
    classDef helpStyle fill:#f3e5f5,stroke:#4a148c,stroke-width:2px
    classDef buildStyle fill:#e8f5e9,stroke:#1b5e20,stroke-width:2px
    classDef testStyle fill:#fff3e0,stroke:#e65100,stroke-width:2px
    classDef runStyle fill:#fce4ec,stroke:#880e4f,stroke-width:2px
    classDef qualityStyle fill:#e0f2f1,stroke:#004d40,stroke-width:2px
    classDef convertStyle fill:#f1f8e9,stroke:#33691e,stroke-width:2px
    classDef compatStyle fill:#eceff1,stroke:#263238,stroke-width:2px
    classDef infoStyle fill:#e3f2fd,stroke:#0d47a1,stroke-width:2px
    classDef packageStyle fill:#fbe9e7,stroke:#bf360c,stroke-width:2px
    classDef debugStyle fill:#ffebee,stroke:#b71c1c,stroke-width:2px

    class ZIG entryStyle
    class HELP helpStyle
    class BUILD,BUILD_EXE,BUILD_LIB,BUILD_OBJ buildStyle
    class TEST,TEST_OBJ testStyle
    class RUN runStyle
    class AST_CHECK,FMT,REDUCE qualityStyle
    class TRANSLATE_C convertStyle
    class AR,CC,CPP,DLLTOOL,LIB,RANLIB,OBJCOPY,RC compatStyle
    class ENV,STD,LIBC,TARGETS,VERSION,ZEN infoStyle
    class FETCH,INIT packageStyle
    class CHANGELIST,DUMP_ZIR,DETECT_CPU,LLVM_INTS debugStyle
```

## コマンド間の関係性

### ビルドフロー

1. **プロジェクト初期化**: `zig init` でプロジェクトを作成
2. **依存関係取得**: `zig fetch` でパッケージをダウンロード
3. **ビルド実行**: `zig build` でプロジェクト全体をビルド

### 直接ビルドフロー

1. **オブジェクト生成**: `zig build-obj` でオブジェクトファイルを生成
2. **ライブラリ作成**: `zig build-lib` でライブラリを作成
3. **実行ファイル作成**: `zig build-exe` で実行ファイルを作成
4. **即時実行**: `zig run` でビルドと実行を同時に行う

### テストフロー

1. **テスト実行**: `zig test` でテストをビルドして実行
2. **テストオブジェクト**: `zig test-obj` でテスト用オブジェクトのみ生成

### コード品質フロー

1. **構文チェック**: `zig ast-check` で構文エラーを検出
2. **フォーマット**: `zig fmt` でコードを整形
3. **バグ最小化**: `zig reduce` でバグレポートを最小化

## 凡例

| カテゴリ | 説明 | 主なコマンド |
|---------|------|-------------|
| ビルド | プロジェクトのビルド関連 | build, build-exe, build-lib, build-obj |
| テスト | テスト実行関連 | test, test-obj |
| 実行 | 即時実行 | run |
| コード品質 | コード品質チェック | ast-check, fmt, reduce |
| 変換 | コード変換 | translate-c |
| 互換ツール | 他ツールとの互換性 | ar, cc, c++, dlltool, lib, ranlib, objcopy, rc |
| 情報 | 情報表示 | env, std, libc, targets, version, zen |
| パッケージ管理 | パッケージ管理 | fetch, init |
| デバッグ | デバッグ用（デバッグモード限定） | changelist, dump-zir, detect-cpu, llvm-ints |
