---
generated_at: 2026-02-01 16:45:00
metrics:
  claims_total: 58
  claims_with_evidence: 55
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：55 / 58、根拠なし：3
- 優先レビュー（高）
  1. **Tracy統合（テスト実行画面）**：テストコマンドとTracyの直接的な連携コードの確認が必要
  2. **fuzzer（テスト実行画面）**：ファジングテストがtestコマンドと連携する具体的なフローの確認が必要
  3. **インクリメンタルコンパイル（実行ファイルビルド画面）**：-fincrementalオプションの具体的な動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - mainArgs関数（コマンドディスパッチ処理、261-392行目）
- E-02: `src/main.zig` - normal_usage定数（コマンドヘルプ文字列、77-119行目）
- E-03: `src/main.zig` - buildOutputType関数（ビルド処理の共通実装、809行目以降）
- E-04: `src/fmt.zig` - run関数（フォーマット処理の実装）
- E-05: `src/print_env.zig` - cmdEnv関数（環境情報表示処理）
- E-06: `src/print_targets.zig` - cmdTargets関数（ターゲット一覧表示処理）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-09: `src/main.zig` - ArgMode列挙型（742-750行目）
- E-10: `src/main.zig` - debug_usage定数（デバッグコマンド定義、121-130行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ヘルプ画面はhelp機能を主機能として使用 | E-01, E-02 | ○ |
| C-02 | プロジェクトビルド画面はbuild機能を主機能として使用 | E-01 (cmdBuild呼び出し) | ○ |
| C-03 | プロジェクトビルド画面は依存関係解決を補助機能として使用 | E-08 (機能一覧の備考) | ○ |
| C-04 | 実行ファイルビルド画面はbuild-exeを主機能として使用 | E-01, E-03 | ○ |
| C-05 | 実行ファイルビルド画面はSemaを補助機能として使用 | E-08 (Semaの説明) | ○ |
| C-06 | 実行ファイルビルド画面はLLVMバックエンドを遷移先機能として使用 | E-08 (バックエンドの説明) | ○ |
| C-07 | 実行ファイルビルド画面はELFリンカを遷移先機能として使用 | E-08 (リンカの説明) | ○ |
| C-08 | 実行ファイルビルド画面はMachOリンカを遷移先機能として使用 | E-08 (リンカの説明) | ○ |
| C-09 | 実行ファイルビルド画面はCOFFリンカを遷移先機能として使用 | E-08 (リンカの説明) | ○ |
| C-10 | ライブラリビルド画面はbuild-libを主機能として使用 | E-01, E-03 | ○ |
| C-11 | ライブラリビルド画面はSemaを補助機能として使用 | E-08 | ○ |
| C-12 | ライブラリビルド画面はLLVMバックエンドを遷移先機能として使用 | E-08 | ○ |
| C-13 | オブジェクトビルド画面はbuild-objを主機能として使用 | E-01, E-03 | ○ |
| C-14 | オブジェクトビルド画面はSemaを補助機能として使用 | E-08 | ○ |
| C-15 | オブジェクトビルド画面はLLVMバックエンドを遷移先機能として使用 | E-08 | ○ |
| C-16 | テスト実行画面はtest機能を主機能として使用 | E-01, E-09 | ○ |
| C-17 | テスト実行画面はSemaを補助機能として使用 | E-08 | ○ |
| C-18 | テストオブジェクト画面はtest-objを主機能として使用 | E-01, E-09 | ○ |
| C-19 | 即時実行画面はrun機能を主機能として使用 | E-01, E-09 | ○ |
| C-20 | 即時実行画面はbuild-exeを補助機能として使用 | E-03 (runの内部実装) | ○ |
| C-21 | AST検査画面はast-checkを主機能として使用 | E-01 (cmdAstCheck呼び出し) | ○ |
| C-22 | AST検査画面はSemaを補助機能として使用 | E-08 | ○ |
| C-23 | フォーマット画面はfmt機能を主機能として使用 | E-01, E-04 | ○ |
| C-24 | バグレポート最小化画面はreduce機能を主機能として使用 | E-01 (jitCmd呼び出し) | ○ |
| C-25 | C言語変換画面はtranslate-cを主機能として使用 | E-01, E-09 | ○ |
| C-26 | アーカイバ画面はar機能を主機能として使用 | E-01 (llvmArMain呼び出し) | ○ |
| C-27 | Cコンパイラ画面はcc機能を主機能として使用 | E-01, E-09 | ○ |
| C-28 | Cコンパイラ画面はlibcサポートを補助機能として使用 | E-08 | ○ |
| C-29 | C++コンパイラ画面はc++機能を主機能として使用 | E-01, E-09 | ○ |
| C-30 | C++コンパイラ画面はlibcxxを補助機能として使用 | E-08 | ○ |
| C-31 | DLLツール画面はdlltoolを主機能として使用 | E-01 (llvmArMain呼び出し) | ○ |
| C-32 | Libツール画面はlib機能を主機能として使用 | E-01 (llvmArMain呼び出し) | ○ |
| C-33 | Ranlibツール画面はranlib機能を主機能として使用 | E-01 (llvmArMain呼び出し) | ○ |
| C-34 | Objcopyツール画面はobjcopy機能を主機能として使用 | E-01 (jitCmd呼び出し) | ○ |
| C-35 | RCツール画面はrc機能を主機能として使用 | E-01 (jitCmd呼び出し) | ○ |
| C-36 | 環境情報画面はenv機能を主機能として使用 | E-01, E-05 | ○ |
| C-37 | 標準ライブラリドキュメント画面はstd機能を主機能として使用 | E-01 (jitCmd呼び出し) | ○ |
| C-38 | libc情報画面はlibc機能を主機能として使用 | E-01 (jitCmd呼び出し) | ○ |
| C-39 | ターゲット一覧画面はtargets機能を主機能として使用 | E-01, E-06 | ○ |
| C-40 | バージョン画面はversion機能を主機能として使用 | E-01 | ○ |
| C-41 | Zen画面はzen機能を主機能として使用 | E-01 | ○ |
| C-42 | パッケージ取得画面はfetch機能を主機能として使用 | E-01 (cmdFetch呼び出し) | ○ |
| C-43 | パッケージ取得画面は依存関係解決を補助機能として使用 | E-08 | ○ |
| C-44 | プロジェクト初期化画面はinit機能を主機能として使用 | E-01 (cmdInit呼び出し) | ○ |
| C-45 | プロジェクト初期化画面はstd.Buildを補助機能として使用 | E-08 | ○ |
| C-46 | 変更リスト画面はchangelist機能を主機能として使用 | E-01, E-10 | ○ |
| C-47 | 変更リスト画面はZIRを補助機能として使用 | E-08, E-10 | ○ |
| C-48 | ZIRダンプ画面はdump-zir機能を主機能として使用 | E-01, E-10 | ○ |
| C-49 | ZIRダンプ画面はZIRを補助機能として使用 | E-08, E-10 | ○ |
| C-50 | CPU検出画面はdetect-cpu機能を主機能として使用 | E-01 | ○ |
| C-51 | LLVM整数ダンプ画面はllvm-ints機能を主機能として使用 | E-01, E-10 | ○ |
| C-52 | 実行ファイルビルド画面はx86_64バックエンドを遷移先機能として使用 | E-08 | ○ |
| C-53 | 実行ファイルビルド画面はaarch64バックエンドを遷移先機能として使用 | E-08 | ○ |
| C-54 | 実行ファイルビルド画面はwasmバックエンドを遷移先機能として使用 | E-08 | ○ |
| C-55 | 実行ファイルビルド画面はWASMリンカを遷移先機能として使用 | E-08 | ○ |
| C-56 | 実行ファイルビルド画面はインクリメンタルコンパイルを補助機能として使用 | E-03 (fincremental変数) | △ |
| C-57 | テスト実行画面はTracy統合を補助機能として使用 | **根拠不足** | △ |
| C-58 | テスト実行画面はfuzzerを補助機能として使用 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **Tracy統合の連携確認**：src/tracy.zigでTracy統合が定義されているが、testコマンドとの直接的な連携コードは確認できていない
  - 候補：src/tracy.zig / src/Compilation.zig / test関連コード
- **fuzzerの連携確認**：lib/fuzzer.zigでファジング機能が定義されているが、testコマンドとの連携フローは未確認
  - 候補：lib/fuzzer.zig / src/main.zig (test関連) / ビルドオプション
- **インクリメンタルコンパイル**：-fincrementalオプションは存在するが、build-exeとの具体的な連携フローの詳細確認が必要
  - 候補：src/main.zig / src/Compilation.zig / 増分コンパイル関連コード

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：主要なコマンドと機能のマッピング（ヘルプ、ビルド、テスト等の主機能）
- **0（低リスク）**：リンカやバックエンドとの連携（明確なアーキテクチャ依存）
- **1（中リスク）**：補助機能のマッピング（Sema、依存関係解決等）- 間接的な呼び出し関係のため
- **2（高リスク）**：Tracy統合、fuzzer、インクリメンタルコンパイル - 直接的な根拠が不足

## 6) レビュアーチェックリスト（最小）
- [ ] main.zigのコマンドディスパッチ部分（261-392行目）と画面一覧の対応を確認
- [ ] 各ビルドコマンド（build-exe, build-lib, build-obj）がbuildOutputType関数を共通使用していることを確認
- [ ] デバッグコマンド（changelist, dump-zir, detect-cpu, llvm-ints）がdebug_usageに定義されていることを確認
- [ ] Tracy統合がtestコマンド実行時に有効化される条件を確認
- [ ] fuzzerがtestコマンドと連携するオプション（-ffuzz）の動作を確認
- [ ] -fincrementalオプションの実際の動作フローを確認
