# 画面設計書 1-ヘルプ画面

## 概要

本ドキュメントは、Zigコンパイラの「ヘルプ画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

ヘルプ画面は、Zigコンパイラの使用方法とコマンド一覧を表示するCLI画面である。ユーザーがZigコマンドの使い方を理解するための最初のエントリポイントとして機能する。

**業務上の目的・背景**：Zigコンパイラは多数のサブコマンドとオプションを持つ複雑なツールである。ユーザーが適切なコマンドを選択し、正しいオプションを指定できるようにするため、包括的なヘルプ情報を提供する必要がある。本画面は、初心者から上級者まで、すべてのユーザーがZigの機能を効率的に活用できるようにするための重要な入口となる。

**画面へのアクセス方法**：以下のいずれかのコマンドで本画面にアクセスできる。
- `zig help`
- `zig -h`
- `zig --help`
- 引数なしで`zig`を実行した場合もヘルプが表示される（エラーメッセージ付き）

**主要な操作・処理内容**：
1. コマンドライン引数を解析し、`help`、`-h`、または`--help`を検出
2. `usage`文字列（コマンド一覧とオプション情報）を標準出力に出力
3. プロセスを正常終了

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：なし（情報表示後にプロセス終了）

**権限による表示制御**：権限による表示制御は存在しない。すべてのユーザーが同一のヘルプ情報を閲覧できる。ただし、デバッグビルドの場合は追加のデバッグコマンド（changelist、dump-zir、detect-cpu、llvm-ints）が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | help | 主機能 | zig help / zig -h / zig --help 実行時のヘルプメッセージ表示処理 |

## 画面種別

情報表示（CLIテキスト出力）

## URL/ルーティング

CLIアプリケーションのため、URLは存在しない。コマンドルーティングは以下の通り。

```
zig help
zig -h
zig --help
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| command | string | - | `help`、`-h`、または`--help`のいずれか |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| usage | string | コマンド一覧とオプション情報を含むヘルプテキスト |

## 表示項目

ヘルプ画面は以下のセクションで構成される。

| セクション | 説明 |
|-----------|------|
| Usage | 基本的な使用方法（`zig [command] [options]`） |
| Commands | 利用可能なコマンド一覧（build、fetch、init、build-exe等） |
| General Options | 共通オプション（`-h, --help`） |
| Debug Commands | デバッグコマンド（デバッグビルドのみ表示） |

## イベント仕様

### 1-ヘルプコマンド実行

ユーザーが`zig help`、`zig -h`、または`zig --help`を実行した場合。

**処理フロー**：
1. `mainArgs`関数でコマンド引数を解析
2. `dev.check(.help_command)`でデバッグチェックを実行
3. `Io.File.stdout().writeStreamingAll(io, usage)`で標準出力にヘルプテキストを出力
4. プロセス正常終了

### 2-引数なし実行

ユーザーが引数なしで`zig`を実行した場合。

**処理フロー**：
1. `main`関数で引数数をチェック（`args.len <= 1`）
2. `std.log.info("{s}", .{usage})`でヘルプテキストをログ出力
3. `fatal("expected command argument", .{})`でエラーメッセージを表示して終了

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 情報 | usage文字列 | help/--help/-hコマンド実行時 |
| - | エラー | "expected command argument" | 引数なしでzig実行時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 標準出力書き込みエラー | 標準出力への書き込み失敗 | エラーを返却 |

## 備考

- デバッグビルド（`build_options.enable_debug_extensions`がtrue）の場合、通常のヘルプに加えてデバッグコマンドセクションが表示される
- ヘルプテキストはコンパイル時に定数として定義されている（`normal_usage`および`debug_usage`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプ画面は単純な文字列出力であり、複雑なデータ構造は使用しない。主要なデータは以下の定数文字列である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `normal_usage`定数（77-119行目）：通常ヘルプテキスト |
| 1-2 | main.zig | `src/main.zig` | `debug_usage`定数（121-130行目）：デバッグコマンド追加テキスト |
| 1-3 | main.zig | `src/main.zig` | `usage`定数（132行目）：ビルド設定に応じた最終ヘルプテキスト |

**読解のコツ**: Zigの複数行文字列リテラル（`\\`で始まる行）に注意。各行が連結されて1つの文字列となる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `main`関数（171-217行目）：プログラムエントリポイント |
| 2-2 | main.zig | `src/main.zig` | `mainArgs`関数（219-393行目）：コマンドディスパッチ |

**主要処理フロー**:
1. **171行目**: `main`関数開始、アロケータ初期化
2. **185行目**: コマンドライン引数をスライスに変換
3. **189-192行目**: 引数がない場合のヘルプ表示とエラー
4. **376-378行目**: `help`/`-h`/`--help`コマンドの処理

#### Step 3: ヘルプ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | helpコマンド分岐（376-378行目） |

**主要処理フロー**:
- **376行目**: `mem.eql`でコマンド文字列を比較
- **377行目**: `dev.check(.help_command)`でデバッグ用チェック
- **378行目**: `Io.File.stdout().writeStreamingAll(io, usage)`で出力

### プログラム呼び出し階層図

```
main (171行目)
    │
    ├─ mainArgs (219行目)
    │      │
    │      ├─ mem.eql (376行目) - コマンド比較
    │      │
    │      ├─ dev.check(.help_command) (377行目) - デバッグチェック
    │      │
    │      └─ Io.File.stdout().writeStreamingAll(io, usage) (378行目) - 出力
    │
    └─ [引数なしの場合]
           │
           ├─ std.log.info (190行目) - ヘルプログ出力
           │
           └─ fatal (191行目) - エラー終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン ───▶ mainArgs関数 ───▶ 標準出力
   引数              (コマンド解析)      (ヘルプテキスト)
   │                     │
   │                     ▼
   │              usage定数参照
   │                     │
   └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | メインエントリポイント、ヘルプテキスト定義、コマンドディスパッチ |
| build_options | (ビルド時生成) | 設定 | `enable_debug_extensions`フラグでデバッグコマンド表示を制御 |
| dev.zig | `src/dev.zig` | ソース | 開発用チェック機能 |
