# 画面設計書 10-フォーマット画面

## 概要

本ドキュメントは、Zigコンパイラの「フォーマット画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

フォーマット画面は、Zigソースコードを標準的なフォーマットに整形するCLI画面である。コードスタイルを統一し、可読性を向上させる。

**業務上の目的・背景**：チーム開発において、コードスタイルの統一は重要である。`zig fmt`コマンドは、Zigの公式スタイルガイドに従ってソースコードを自動整形する。これにより、コードレビューでスタイルに関する議論を減らし、本質的なロジックのレビューに集中できる。また、エディタの保存時フックや CI/CD パイプラインでの使用により、常に一貫したスタイルを維持できる。

**画面へのアクセス方法**：
- `zig fmt [ファイル]` - ファイルをフォーマット
- `zig fmt [ディレクトリ]` - ディレクトリ内の全.zig/.zonファイルを再帰的にフォーマット
- `zig fmt --stdin` - 標準入力からコードを読み取りフォーマット
- `zig fmt --check [ファイル]` - フォーマットが必要なファイルを報告（変更なし）

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ファイルまたはディレクトリの走査
3. 各ファイルのパースと整形
4. 整形結果の書き込み（または標準出力への出力）

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：フォーマット完了後にプロセス終了

**権限による表示制御**：権限による表示制御は存在しない。ファイルの書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | fmt | 主機能 | Zigソースコードを正規フォーマットに整形する処理 |
| 47 | ZIR | 補助機能 | フォーマット時のZig中間表現処理（--ast-checkオプション） |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig fmt [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | - | フォーマット対象のファイルまたはディレクトリ |
| --stdin | - | - | 標準入力からコードを読み取り |
| --check | - | - | フォーマットが必要なファイルの報告のみ |
| --ast-check | - | - | 各ファイルでast-checkを実行 |
| --exclude | path | - | 除外するファイル/ディレクトリ |
| --zon | - | - | すべての入力をZONとして扱う |
| --color | auto/on/off | - | 色付き出力の制御 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フォーマット済みコード | text | --stdin使用時のフォーマット結果 |
| 変更ファイル一覧 | text | フォーマットされたファイルのリスト |
| エラーメッセージ | text | パースエラー等 |

## 表示項目

| セクション | 説明 |
|-----------|------|
| 処理ファイル | フォーマットされたファイルのパス |
| パースエラー | 構文エラーがあった場合の詳細 |

## イベント仕様

### 1-ファイルフォーマット

ユーザーが`zig fmt [ファイル]`を実行した場合。

**処理フロー**：
1. `run`関数で引数を解析
2. ファイルを読み込み
3. ASTを生成
4. `tree.renderAlloc`で整形
5. 元ファイルに書き込み

### 2-ディレクトリフォーマット

ディレクトリを指定した場合。

**処理フロー**：
1. ディレクトリを再帰的に走査
2. .zigおよび.zonファイルを収集
3. 各ファイルに対してフォーマット処理

### 3-チェックモード

`--check`オプションが指定された場合。

**処理フロー**：
1. ファイルをパースして整形
2. 整形結果と元のコードを比較
3. 差異があるファイルを標準出力に報告
4. 差異があれば終了コード1で終了

### 4-標準入力フォーマット

`--stdin`オプションが指定された場合。

**処理フロー**：
1. 標準入力からコードを読み取り
2. パースして整形
3. 標準出力に整形結果を出力

## データベース更新仕様

本画面はデータベースを使用しない。ファイルシステムを更新する。

### 操作別影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーマット実行 | ソースファイル | UPDATE | フォーマット済みコードで上書き |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 情報 | ファイルパス | フォーマット完了時 |
| - | エラー | "unable to format" | フォーマット失敗時 |
| - | エラー | パースエラー詳細 | 構文エラー時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | 指定されたファイルが存在しない | エラーメッセージを表示 |
| パースエラー | ソースコードに構文エラー | エラー詳細を表示 |
| 書き込みエラー | ファイルに書き込めない | エラーメッセージを表示 |

## 備考

- .で始まるファイル/ディレクトリは自動的にスキップされる
- `--exclude`オプションで特定のファイル/ディレクトリを除外可能
- `--ast-check`オプションでフォーマットと同時に構文チェックを実行可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fmt.zig | `src/fmt.zig` | `Fmt`構造体（30-43行目）：フォーマット処理の状態 |
| 1-2 | fmt.zig | `src/fmt.zig` | `usage_fmt`定数（10-27行目）：ヘルプテキスト |

**読解のコツ**: fmtは独立したモジュール（fmt.zig）で実装されており、main.zigから呼び出される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（318-320行目）：fmtへのディスパッチ |
| 2-2 | fmt.zig | `src/fmt.zig` | `run`関数（45-205行目）：フォーマットのメイン処理 |

**主要処理フロー**:
1. **318行目（main.zig）**: `mem.eql(u8, cmd, "fmt")`でコマンド判定
2. **319行目（main.zig）**: `dev.check(.fmt_command)`でデバッグチェック
3. **320行目（main.zig）**: `@import("fmt.zig").run`を呼び出し
4. **45行目（fmt.zig）**: `run`関数開始
5. **56-94行目（fmt.zig）**: 引数解析ループ
6. **97-158行目（fmt.zig）**: --stdin処理
7. **167-204行目（fmt.zig）**: ファイル/ディレクトリ処理

#### Step 3: ファイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fmt.zig | `src/fmt.zig` | `fmtPath`関数（207-216行目）：パス処理のエントリ |
| 3-2 | fmt.zig | `src/fmt.zig` | `fmtPathFile`関数（256-365行目）：ファイルフォーマット処理 |
| 3-3 | fmt.zig | `src/fmt.zig` | `fmtPathDir`関数（218-254行目）：ディレクトリ走査 |

**主要処理フロー**:
- **297行目**: `std.zig.Ast.parse`でASTを生成
- **348行目**: `tree.render`で整形
- **351行目**: 元のコードと比較
- **358-363行目**: ファイルにアトミック書き込み

#### Step 4: 整形処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fmt.zig | `src/fmt.zig` | --ast-check処理（306-342行目） |

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ @import("fmt.zig").run (320行目)
                  │
                  ├─ 引数解析 (56-94行目)
                  │      ├─ --stdin
                  │      ├─ --check
                  │      ├─ --ast-check
                  │      └─ --exclude
                  │
                  ├─ [--stdinモード] (97-158行目)
                  │      │
                  │      ├─ stdinから読み込み
                  │      ├─ Ast.parse
                  │      ├─ tree.renderAlloc
                  │      └─ stdoutに出力
                  │
                  └─ [ファイルモード] (167-204行目)
                         │
                         └─ fmtPath (207行目)
                                │
                                ├─ [ファイル]
                                │      │
                                │      └─ fmtPathFile (256行目)
                                │             ├─ ファイル読み込み
                                │             ├─ Ast.parse
                                │             ├─ tree.render
                                │             └─ アトミック書き込み
                                │
                                └─ [ディレクトリ]
                                       │
                                       └─ fmtPathDir (218行目)
                                              ├─ ディレクトリ走査
                                              ├─ .zig/.zonファイル収集
                                              └─ 各ファイルに fmtPathFile
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig/.zon ───────────────▶ run関数 ─────────────────────▶ フォーマット済み
   │                           │                          ファイル
   │                           ▼
   │                      fmtPath
   │                           │
   │                           ▼
   │                      [ファイル/ディレクトリ判定]
   │                           │
   ├── fmtPathFile ◀───────────┤
   │        │                  │
   │        ▼                  └─── fmtPathDir
   │   Ast.parse                      │
   │        │                         ▼
   │        ▼                    ディレクトリ走査
   │   tree.render                    │
   │        │                         ▼
   │        ▼                    再帰的にfmtPath
   │   [比較・書き込み]
   │
--stdin ─────────────────────────────▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fmt.zig | `src/fmt.zig` | ソース | フォーマット処理の実装 |
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Ast（標準ライブラリ） | `lib/std/zig/Ast.zig` | ソース | AST定義とパース/レンダリング |
| AstGen（標準ライブラリ） | `lib/std/zig/AstGen.zig` | ソース | ZIR生成（--ast-check用） |
| ZonGen（標準ライブラリ） | `lib/std/zig/ZonGen.zig` | ソース | ZOIR生成（--ast-check用） |
