# 画面設計書 11-バグレポート最小化画面

## 概要

本ドキュメントは、Zigコンパイラの`zig reduce`コマンドによるバグレポート最小化機能の画面設計書である。コンパイラバグを再現する最小限のコードを自動的に生成するためのCLIインターフェースを定義する。

### 本画面の処理概要

`zig reduce`コマンドは、Zigソースコードのバグレポートを最小化するためのデバッグ支援ツールである。コンパイラや言語ランタイムのバグを報告する際に、問題を再現する最小限のコードを自動的に特定する。

**業務上の目的・背景**：コンパイラのバグを報告する際、大規模なプロジェクトコードをそのまま提出すると、開発者が問題を特定するのに時間がかかる。本ツールは、Delta Debuggingアルゴリズムを用いてソースコードを自動的に削減し、バグを再現する最小限のコードを生成することで、バグ報告の品質向上とコンパイラ開発者の調査時間短縮に貢献する。

**画面へのアクセス方法**：ターミナルから`zig reduce [options] ./checker root_source_file.zig [-- [argv]]`コマンドを実行してアクセスする。checkerは興味深さを判定する外部実行ファイルのパスであり、root_source_file.zigは最小化対象のZigソースファイルである。

**主要な操作・処理内容**：
1. 興味深さチェッカー（interestingness checker）の指定と実行
2. Zigソースファイルの構文解析とAST変換リストの生成
3. ランダムな変換のサブセット適用による削減候補の生成
4. 興味深さチェックによる削減結果の検証
5. 成功した削減の永続化と次のイテレーションへの継続
6. 最終的な最小化されたソースコードの出力

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | reduce | 主機能 | バグレポートを最小化するデバッグ支援処理 |
| 47 | ZIR | 補助機能 | ソースコードのZig中間表現への変換と未使用変数の検出 |

## 画面種別

コマンドライン・インターフェース（CLI）- デバッグ支援ツール

## URL/ルーティング

```
zig reduce [options] ./checker root_source_file.zig [-- [argv]]
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| checker | 入力 | ファイルパス | 必須 | 興味深さを判定する実行ファイルのパス |
| root_source_file | 入力 | ファイルパス | 必須 | 最小化対象のZigソースファイル |
| --seed | 入力 | 32bit整数 | 任意 | 乱数シード（デフォルト: 0） |
| --skip-smoke-test | 入力 | フラグ | 任意 | 初回の興味深さチェックをスキップ |
| --mod | 入力 | 文字列 | 任意 | モジュールの依存関係を設定（未実装） |
| --deps | 入力 | 文字列 | 任意 | ルートパッケージの依存関係を設定（未実装） |
| --main-mod-path | 入力 | ディレクトリパス | 任意 | ルートモジュールのディレクトリを設定（未実装） |
| argv | 入力 | 文字列配列 | 任意 | チェッカーに渡す追加引数（`--`の後に指定） |
| 最小化されたソースコード | 出力 | ファイル | - | 元のファイルを上書きして出力 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| smoke test結果 | 初回の興味深さチェック結果 |
| 変換候補数 | 見つかった可能な変換の数 |
| 試行中の変換 | 現在試行中の変換の種類と数 |
| 変換結果 | 各変換セットの興味深さ判定結果（interesting/boring/unknown） |
| 進捗状況 | 現在の試行インデックスと総変換数 |

## イベント仕様

### 1-コマンド実行

ユーザーが`zig reduce`コマンドを実行すると、以下の処理フローが開始される：

1. コマンドライン引数の解析
2. チェッカーパスとソースファイルパスの検証
3. スモークテストの実行（--skip-smoke-testが指定されていない場合）
4. AST変換リストの生成
5. Delta Debuggingアルゴリズムによる削減ループ
6. 最終結果のファイル出力

### 2-興味深さチェック

チェッカープログラムの終了コードによって結果を判定：
- exit(0): interesting（興味深い - バグが再現される）
- exit(1): unknown（不明 - 無限ループなどの問題）
- exit(その他): not interesting（興味深くない - バグが再現されない）

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | smoke testing the interestingness check... | スモークテスト開始時 |
| MSG002 | エラー | interestingness check returned {result} for unmodified input | スモークテストが失敗した場合 |
| MSG003 | 情報 | found {N} possible transformations | 変換候補が見つかった場合 |
| MSG004 | 情報 | trying {N} random transformations: {types} | 変換を試行する際 |
| MSG005 | 情報 | {N} random transformations: {result}. {index}/{total} | 各試行の結果表示 |
| MSG006 | 情報 | all {N} remaining transformations are uninteresting | 全変換が興味深くない場合 |
| MSG007 | 情報 | no more transformations found | これ以上の変換が見つからない場合 |
| MSG008 | エラー | missing interestingness checker argument | チェッカーパスが未指定 |
| MSG009 | エラー | missing root source file path argument | ソースファイルパスが未指定 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| チェッカーパス未指定 | エラーメッセージを表示して終了 |
| ソースファイル未指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| 構文解析エラー | エラーメッセージを表示して終了 |
| チェッカー実行失敗 | シグナル情報と共にエラーを表示 |
| スモークテスト失敗 | 未変更入力が興味深くないとしてエラー終了 |

## 備考

- 本機能はDelta Debuggingアルゴリズムの変種を使用している
- 変換はランダムにシャッフルされ、サブセットサイズを段階的に縮小しながら試行される
- 未使用変数の検出にはZIR（Zig Intermediate Representation）のコンパイルエラーチェックを使用
- --mod、--deps、--main-mod-pathオプションは現在未実装（TODO）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、バグ最小化で使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Walk.zig | `lib/compiler/reduce/Walk.zig` | Transformationの種類とAST走査ロジック |
| 1-2 | Ast.zig | `lib/std/zig/Ast.zig` | ZigのASTノード構造とrender関数 |

**読解のコツ**: Transformationは削除可能なコード要素（関数、引数、文など）を表す。Walk.zigのfindTransformations関数がASTを走査して変換候補を収集する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | jitCmd関数によるreduce.zigの動的コンパイルと実行 |
| 2-2 | reduce.zig | `lib/compiler/reduce.zig` | main関数とDelta Debuggingアルゴリズムの実装 |

**主要処理フロー**:
1. **368-372行目**: `zig reduce`コマンドの検出とjitCmd呼び出し
2. **5533-5750行目**: jitCmd関数によるJITコンパイルと子プロセス実行
3. **reduce.zig 50-274行目**: main関数のDelta Debuggingループ

#### Step 3: 興味深さチェック処理を理解する

チェッカープロセスの実行と結果判定のロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reduce.zig | `lib/compiler/reduce.zig` | runCheck関数とtermToInteresting関数 |

**主要処理フロー**:
- **283-298行目**: プロセス終了コードから興味深さへの変換ロジック

#### Step 4: 変換とレンダリング処理を理解する

ASTへのfixup適用とソースコード再生成のロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | reduce.zig | `lib/compiler/reduce.zig` | transformationsToFixups関数 |
| 4-2 | Ast.zig | `lib/std/zig/Ast.zig` | render関数とFixups構造体 |

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ jitCmd() [368-372行目]
    │      │
    │      ├─ Compilation.create() - reduceをJITコンパイル
    │      │
    │      └─ process.replace() / spawn() - reduce実行ファイルを実行
    │
    └─ reduce.zig (main関数)
           │
           ├─ parse() - Zigソースのパース
           │
           ├─ runCheck() - スモークテスト
           │      └─ termToInteresting() - 終了コード判定
           │
           ├─ Walk.findTransformations() - 変換候補収集
           │
           └─ [Delta Debuggingループ]
                  │
                  ├─ transformationsToFixups() - 変換をFixupsに適用
                  │
                  ├─ tree.render() - ソースコード再生成
                  │
                  ├─ AstGen.generate() - ZIRへの変換（未使用変数検出）
                  │
                  ├─ Io.Dir.cwd().writeFile() - ファイル書き込み
                  │
                  └─ runCheck() - 興味深さ判定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Zigソースファイル ──────▶ parse() ──────▶ Ast構造体
     │
     │                    Walk.findTransformations()
     ▼                           │
AST構造体 ─────────────▶ 変換候補リスト
     │
     │                    シャッフル + サブセット選択
     ▼
変換サブセット ─────────▶ transformationsToFixups() ──▶ Fixups
     │
     │                    tree.render()
     ▼
Fixups ─────────────────▶ 削減されたソースコード
     │
     │                    AstGen.generate() (ZIR検証)
     ▼
削減ソース ──────────────▶ runCheck() ─────────────────▶ 興味深さ結果
     │
     ▼                    [ループ継続 or 終了]
最小化されたソース ─────▶ ファイル書き込み ────────────▶ 元ファイル上書き
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとjitCmd関数 |
| reduce.zig | `lib/compiler/reduce.zig` | ソース | バグ最小化のメインロジック |
| Walk.zig | `lib/compiler/reduce/Walk.zig` | ソース | AST走査と変換候補の収集 |
| Ast.zig | `lib/std/zig/Ast.zig` | ソース | AST構造体とレンダリング機能 |
| AstGen.zig | `lib/std/zig/AstGen.zig` | ソース | ASTからZIRへの変換と未使用変数検出 |
| Zir.zig | `lib/std/zig/Zir.zig` | ソース | Zig Intermediate Representation定義 |
| dev.zig | `src/dev.zig` | ソース | 開発モード機能フラグ |
