# 画面設計書 12-C言語変換画面

## 概要

本ドキュメントは、Zigコンパイラの`zig translate-c`コマンドによるC言語からZig言語への変換機能の画面設計書である。CソースコードをZigソースコードに自動変換するCLIインターフェースを定義する。

### 本画面の処理概要

`zig translate-c`コマンドは、CソースコードをZigソースコードに自動変換するツールである。既存のCコードベースをZigに移行する際や、CヘッダーファイルをZigから利用する際に使用される。

**業務上の目的・背景**：ZigはCとの高い相互運用性を特徴としており、既存のCライブラリやコードベースを活用できる。本ツールは、Cコードを機械的にZigコードに変換することで、CからZigへの段階的な移行を支援する。また、Cヘッダーファイルを変換することで、@cImport機能の代替としても使用できる。変換されたコードは人間による調整が必要な場合があるが、移行作業の大幅な効率化に貢献する。

**画面へのアクセス方法**：ターミナルから`zig translate-c [options] <source_file.c>`コマンドを実行してアクセスする。

**主要な操作・処理内容**：
1. Cソースファイルの読み込み
2. Clang/aroによるCコードの解析
3. C ASTからZig ASTへの変換
4. Zigソースコードのレンダリングと出力
5. キャッシュマニフェストの管理

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。変換結果は標準出力またはファイルに出力される。

**権限による表示制御**：特になし。ファイルシステムの読み取り権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | translate-c | 主機能 | CコードをZigコードに変換する処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 変換ツール

## URL/ルーティング

```
zig translate-c [options] <source_file.c>
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| source_file | 入力 | ファイルパス | 必須 | 変換対象のCソースファイル |
| -target | 入力 | 文字列 | 任意 | ターゲットアーキテクチャ（例: x86_64-linux-gnu） |
| -O | 入力 | 列挙型 | 任意 | 最適化モード（Debug/ReleaseFast/ReleaseSafe/ReleaseSmall） |
| -I | 入力 | ディレクトリパス | 任意 | インクルードパスの追加（複数指定可） |
| -D | 入力 | 文字列 | 任意 | マクロ定義（複数指定可） |
| -isystem | 入力 | ディレクトリパス | 任意 | システムインクルードパスの追加 |
| --libc | 入力 | ファイルパス | 任意 | libcパスファイルの指定 |
| -cflags | 入力 | 文字列配列 | 任意 | Cコンパイラへの追加フラグ |
| Zigソースコード | 出力 | テキスト | - | 変換されたZigコード（標準出力） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 変換されたZigコード | Cソースから変換されたZigソースコード |
| エラーメッセージ | 変換エラーが発生した場合のエラー情報 |
| 警告メッセージ | 変換時の警告情報 |

## イベント仕様

### 1-コマンド実行

ユーザーが`zig translate-c`コマンドを実行すると、以下の処理フローが開始される：

1. コマンドライン引数の解析
2. Cソースファイルの検証
3. Cフロントエンド（Clang/aro）による解析
4. C ASTからZig ASTへの変換
5. Zigソースコードのレンダリング
6. 標準出力への結果出力

### 2-キャッシュヒット時

変換結果がキャッシュに存在する場合：
1. キャッシュマニフェストの確認
2. キャッシュされた.zigファイルの読み込み
3. 標準出力への出力

### 3-キャッシュミス時

変換結果がキャッシュにない場合：
1. Cソースの完全な解析と変換
2. 結果の.zigファイルをキャッシュに保存
3. マニフェストの更新
4. 標準出力への出力

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムキャッシュのみ操作）

### キャッシュファイル構造

| ディレクトリ | 内容 |
|-------------|------|
| {cache}/o/{hash}/ | 変換結果の.zigファイル |
| {cache}/manifest/ | キャッシュマニフェストファイル |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | translate-c expects exactly 1 source file (found {N}) | ソースファイルが1つでない場合 |
| MSG002 | エラー | unable to open cached translated zig file | キャッシュファイルが開けない場合 |
| MSG003 | エラー | unable to process '{file}' | ファイル処理エラー |
| MSG004 | 警告 | failed to write cache manifest | マニフェスト書き込み失敗 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ソースファイル未指定 | エラーメッセージを表示して終了（終了コード1） |
| 複数ソースファイル指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| C構文解析エラー | Clangエラーメッセージを表示して終了 |
| 変換不可能な構文 | 可能な限り変換し、変換不可部分はコメントで警告 |
| キャッシュ書き込み失敗 | 警告を出力して処理継続 |

## 備考

- LLVM拡張機能が必要（Clangフロントエンドを使用）
- aroフロントエンドも利用可能（JITコンパイル版）
- 変換結果はキャッシュされ、同一入力に対する再変換は高速化される
- マクロや一部のC構文は完全には変換できない場合がある
- @cImport機能の内部でも同様の変換処理が使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、C言語からZigへの変換で使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | CImportResult構造体とtranslateC関数の戻り値 |
| 1-2 | Ast.zig | `lib/std/zig/Ast.zig` | 変換後のZig AST構造 |

**読解のコツ**: CImportResultはdigest（キャッシュハッシュ）、cache_hit（キャッシュヒット有無）、errors（エラーバンドル）を含む。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | translate-cコマンドのディスパッチとbuildOutputType関数 |
| 2-2 | main.zig | `src/main.zig` | cmdTranslateC関数の実装 |

**主要処理フロー**:
1. **306-308行目**: `zig translate-c`コマンドの検出とbuildOutputType呼び出し
2. **1025-1028行目**: translate_cモードの初期化（emit_bin = no, output_mode = Obj）
2. **3718-3719行目**: cmdTranslateC関数の呼び出し
3. **4641-4721行目**: cmdTranslateC関数の実装

#### Step 3: キャッシュ処理を理解する

キャッシュヒット判定と結果の永続化ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | Cache.Manifestによるキャッシュ管理 |
| 3-2 | Compilation.zig | `src/Compilation.zig` | translateC関数の実装 |

**主要処理フロー**:
- **4658-4660行目**: キャッシュマニフェストの初期化
- **4668-4698行目**: キャッシュヒット判定と変換処理

#### Step 4: JITコンパイル版の理解

aroフロントエンドを使用するJIT版の処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.zig | `src/main.zig` | translateC関数（JIT版） |
| 4-2 | main.zig | `lib/compiler/translate-c/main.zig` | JIT版のメイン関数（存在する場合） |

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [translate-cコマンド検出] (306-308行目)
    │      │
    │      └─ buildOutputType() - translate_cモードで呼び出し
    │             │
    │             ├─ [引数解析・Compilation作成]
    │             │
    │             └─ cmdTranslateC() (3718-3719行目)
    │                    │
    │                    ├─ Cache.Manifest初期化 (4658行目)
    │                    │
    │                    ├─ man.hit() - キャッシュヒット判定
    │                    │      │
    │                    │      ├─ [ヒット時] キャッシュからdigest取得
    │                    │      │
    │                    │      └─ [ミス時] comp.translateC()
    │                    │             │
    │                    │             └─ Clang/aroによるC解析・変換
    │                    │
    │                    ├─ [エラー時] errors.renderToStderr()
    │                    │
    │                    └─ [成功時] zig_file読み込み → stdout出力
    │
    └─ translateC() (4724-4740行目) - JIT版
           │
           └─ jitCmd() - translate-c/main.zigをJITコンパイル実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Cソースファイル ─────────▶ Clang/aro解析 ────────▶ C AST
     │
     │                    C AST → Zig AST変換
     ▼
C AST ────────────────────▶ translate処理 ─────────▶ Zig AST
     │
     │                    Zig ASTレンダリング
     ▼
Zig AST ──────────────────▶ render() ───────────────▶ Zigソースコード
     │
     ├──────────────────────────────────────────────▶ キャッシュ保存
     │                                                  │
     └──────────────────────────────────────────────▶ 標準出力
                                                        │
                                                        ▼
                                                   ユーザー/ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとcmdTranslateC関数 |
| Compilation.zig | `src/Compilation.zig` | ソース | translateC関数とCImportResult構造体 |
| Config.zig | `src/Compilation/Config.zig` | ソース | translate-c設定オプション |
| dev.zig | `src/dev.zig` | ソース | translate_c_command機能フラグ |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | Clang FFIバインディング |
| Ast.zig | `lib/std/zig/Ast.zig` | ソース | Zig AST構造体とレンダリング |
| Cache.zig | `lib/std/Build/Cache.zig` | ソース | キャッシュマニフェスト管理 |
