# 画面設計書 13-アーカイバ画面

## 概要

本ドキュメントは、Zigコンパイラの`zig ar`コマンドによるアーカイバ機能の画面設計書である。GNU arやllvm-arとの互換性を持つドロップインアーカイバとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig ar`コマンドは、ZigをGNU arやllvm-arのドロップイン代替として使用するためのツールである。静的ライブラリ（.aファイル）の作成、更新、抽出を行う。

**業務上の目的・背景**：CやC++プロジェクトでは静的ライブラリの作成にarコマンドが使用される。Zigコンパイラに組み込まれたarは、追加のツールチェーンをインストールすることなく、クロスプラットフォームで静的ライブラリを操作できる。これにより、ビルドシステムの依存関係を削減し、Zigのクロスコンパイル機能と組み合わせて任意のターゲット向けのライブラリを作成できる。

**画面へのアクセス方法**：ターミナルから`zig ar [operation] [archive] [member...]`コマンドを実行してアクセスする。GNU ar互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. 静的ライブラリ（アーカイブ）の作成（r, q操作）
2. アーカイブへのオブジェクトファイルの追加・更新
3. アーカイブからのファイル抽出（x操作）
4. アーカイブ内容の一覧表示（t操作）
5. アーカイブからのファイル削除（d操作）
6. シンボルテーブルの更新（s操作）

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | ar | 主機能 | ドロップインアーカイバとしての静的ライブラリ作成処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig ar [options] [operation] [relpos] [count] [archive] [member...]
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| operation | 入力 | 文字 | 必須 | 操作種別（r, d, q, t, x, s） |
| archive | 入力 | ファイルパス | 必須 | アーカイブファイル（.a） |
| member | 入力 | ファイルパス | 任意 | 操作対象のオブジェクトファイル（複数可） |
| modifiers | 入力 | 文字列 | 任意 | 操作修飾子（c, s, v, u, など） |
| --plugin | 入力 | 文字列 | 任意 | LTOプラグイン指定（互換性のため） |
| --version | 入力 | フラグ | 任意 | バージョン情報を表示 |
| アーカイブファイル | 出力 | ファイル | - | 作成・更新されたアーカイブ |
| ファイルリスト | 出力 | テキスト | - | アーカイブ内容一覧（t操作時） |
| 抽出ファイル | 出力 | ファイル | - | 抽出されたオブジェクトファイル（x操作時） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ファイル一覧 | アーカイブ内のファイル名リスト（t操作時） |
| 操作ログ | 追加・更新・削除されたファイル名（v修飾子使用時） |
| バージョン情報 | LLVMバージョンとプラットフォーム情報 |

## イベント仕様

### 1-アーカイブ作成（r操作）

```
zig ar rcs libfoo.a foo.o bar.o
```

1. 指定されたオブジェクトファイルの読み込み
2. アーカイブヘッダーの生成
3. オブジェクトファイルのアーカイブへの追加
4. シンボルテーブルの生成（s修飾子）
5. アーカイブファイルの書き込み

### 2-内容一覧表示（t操作）

```
zig ar t libfoo.a
```

1. アーカイブファイルの読み込み
2. アーカイブメンバーの列挙
3. 各メンバー名の標準出力への出力

### 3-ファイル抽出（x操作）

```
zig ar x libfoo.a
```

1. アーカイブファイルの読み込み
2. 各メンバーの抽出
3. カレントディレクトリへのファイル書き込み

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig ar`, `zig dlltool`, `zig ranlib', and `zig lib` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | 情報 | a - {filename} | ファイル追加時（v修飾子） |
| MSG003 | 情報 | r - {filename} | ファイル置換時（v修飾子） |
| MSG004 | 情報 | d - {filename} | ファイル削除時（v修飾子） |
| MSG005 | 情報 | x - {filename} | ファイル抽出時（v修飾子） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| アーカイブファイル未指定 | エラーメッセージを表示して終了 |
| オブジェクトファイル読み込み失敗 | エラーメッセージを表示して終了 |
| アーカイブ書き込み失敗 | エラーメッセージを表示して終了 |
| 不正なアーカイブ形式 | エラーメッセージを表示して終了 |

## 備考

- 本機能はLLVM拡張機能が必要（llvm-arを内部で使用）
- GNU ar互換のコマンドライン構文をサポート
- zig dlltool、zig ranlib、zig libも同じ関数（llvmArMain）を使用
- LTOプラグイン指定は互換性のために受け付けるが、LLVMのデフォルト動作を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

arコマンドはLLVMのllvm-arを直接呼び出すため、Zig側のデータ構造は最小限である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | llvmArMain関数の引数形式 |

**読解のコツ**: arコマンドはLLVMのFFI経由で処理されるため、コマンドライン引数はそのままLLVMに渡される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | ar/dlltool/ranlib/libコマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | llvmArMain関数の実装 |

**主要処理フロー**:
1. **279-285行目**: ar/dlltool/ranlib/libコマンドの検出とllvmArMain呼び出し
2. **5798-5810行目**: llvmArMain関数の実装
3. **5774行目**: ZigLlvmAr_main外部関数宣言

#### Step 3: LLVM FFIを理解する

LLVMへのFFI呼び出しの仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | argsCopyZ関数（引数のnull終端変換） |
| 3-2 | bindings.zig | `src/codegen/llvm/bindings.zig` | LLVM C APIバインディング |

**主要処理フロー**:
- **5776-5782行目**: argsCopyZ関数で引数をC形式に変換
- **5808-5809行目**: ZigLlvmAr_mainの呼び出しと終了コード変換

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [ar/dlltool/ranlib/libコマンド検出] (279-285行目)
    │      │
    │      └─ dev.check(.ar_command)
    │
    └─ llvmArMain() (5798行目)
           │
           ├─ [LLVM拡張チェック] (5799-5800行目)
           │      │
           │      └─ build_options.have_llvm確認
           │
           ├─ ArenaAllocator初期化
           │
           ├─ argsCopyZ() (5808行目)
           │      │
           │      └─ 引数をnull終端配列に変換
           │
           └─ ZigLlvmAr_main() (5809行目) [FFI]
                  │
                  └─ LLVM llvm-ar実装を呼び出し
                         │
                         └─ 終了コードを返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──────▶ mainArgs() ─────────────▶ コマンド判定
     │
     │                    llvmArMain()
     ▼
[]const []const u8 ──────▶ argsCopyZ() ────────────▶ [:null]?[*:0]u8
     │
     │                    ZigLlvmAr_main() [FFI]
     ▼
C形式引数配列 ───────────▶ LLVM llvm-ar ────────────▶ 終了コード
     │
     ├─ [r操作] ─────────────────────────────────────▶ .aアーカイブファイル
     │
     ├─ [t操作] ─────────────────────────────────────▶ ファイル一覧（stdout）
     │
     └─ [x操作] ─────────────────────────────────────▶ 抽出されたファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとllvmArMain関数 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| build_options.zig | `src/build_options.zig` | 生成ファイル | have_llvmフラグ定義 |
| dev.zig | `src/dev.zig` | ソース | ar_command機能フラグ |
