# 画面設計書 14-Cコンパイラ画面

## 概要

本ドキュメントは、Zigコンパイラの`zig cc`コマンドによるCコンパイラ機能の画面設計書である。GCCやClangとの互換性を持つドロップインCコンパイラとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig cc`コマンドは、ZigをGCCやClangのドロップイン代替として使用するためのCコンパイラツールである。Cソースコードのコンパイル、リンク、各種プラットフォーム向けのクロスコンパイルを行う。

**業務上の目的・背景**：従来のCプロジェクトでは、ターゲットプラットフォームごとに異なるツールチェーン（GCC、MSVC、Clangなど）が必要であった。Zigのccコマンドは単一のバイナリで多数のプラットフォーム向けにCコードをクロスコンパイルできる。また、Zigプロジェクト内でCライブラリを利用する際にも、一貫したビルド環境を提供する。特に、glibc、musl、mingwなど複数のlibc実装をバンドルしているため、追加のSDKなしでクロスコンパイルが可能である。

**画面へのアクセス方法**：ターミナルから`zig cc [options] source.c`コマンドを実行してアクセスする。GCC/Clang互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. Cソースファイルのプリプロセス
2. Cコードのコンパイル（Clangフロントエンド使用）
3. オブジェクトファイルの生成
4. リンク処理（LLD使用）
5. 実行ファイルまたはライブラリの生成

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | cc | 主機能 | Zigをドロップイン Cコンパイラとして使用する処理 |
| 62 | libcサポート | 補助機能 | 各種libc実装（glibc、musl、mingw等）のサポート |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig cc [options] source.c...
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| source files | 入力 | ファイルパス | 必須 | Cソースファイル（複数可） |
| -o | 入力 | ファイルパス | 任意 | 出力ファイル名 |
| -c | 入力 | フラグ | 任意 | コンパイルのみ（リンクしない） |
| -target | 入力 | 文字列 | 任意 | ターゲットトリプル（例: x86_64-linux-gnu） |
| -O | 入力 | 文字列 | 任意 | 最適化レベル（0, 1, 2, 3, s, z） |
| -I | 入力 | ディレクトリパス | 任意 | インクルードパス追加 |
| -L | 入力 | ディレクトリパス | 任意 | ライブラリパス追加 |
| -l | 入力 | 文字列 | 任意 | リンクするライブラリ |
| -D | 入力 | 文字列 | 任意 | マクロ定義 |
| -std | 入力 | 文字列 | 任意 | C言語標準（c99, c11, c17等） |
| -W | 入力 | 文字列 | 任意 | 警告オプション |
| -f | 入力 | 文字列 | 任意 | 機能フラグ |
| 出力ファイル | 出力 | ファイル | - | 生成された実行ファイル/オブジェクト/ライブラリ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| コンパイルエラー | Cソースの構文・意味エラー |
| リンクエラー | 未解決シンボル、ライブラリ不足等 |
| 警告メッセージ | コンパイラ警告 |
| verbose出力 | -v指定時の詳細コンパイル情報 |

## イベント仕様

### 1-コンパイルと実行ファイル生成

```
zig cc -o hello hello.c
```

1. コマンドライン引数の解析
2. Cソースのプリプロセス
3. Clangによるコンパイル
4. オブジェクトファイル生成
5. LLDによるリンク
6. 実行ファイル出力

### 2-オブジェクトファイルのみ生成

```
zig cc -c hello.c
```

1. コマンドライン引数の解析
2. Cソースのプリプロセス
3. Clangによるコンパイル
4. オブジェクトファイル出力（リンクなし）

### 3-クロスコンパイル

```
zig cc -target aarch64-linux-gnu -o hello hello.c
```

1. ターゲットプラットフォームの解決
2. 対応するlibcの選択
3. クロスコンパイル実行
4. ターゲット用バイナリ出力

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig cc` and `zig c++` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | エラー | error: {file}:{line}:{col}: {message} | コンパイルエラー発生時 |
| MSG003 | 警告 | warning: {file}:{line}:{col}: {message} | コンパイル警告発生時 |
| MSG004 | エラー | undefined reference to '{symbol}' | リンク時の未解決シンボル |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| ソースファイル未指定 | エラーメッセージを表示して終了 |
| 構文エラー | Clangエラーメッセージを表示して終了 |
| リンクエラー | LLDエラーメッセージを表示して終了 |
| ターゲット非対応 | サポートされていないターゲットとしてエラー |
| libc無効化時の自動検出 | 再帰呼び出し防止メカニズムが発動 |

## 備考

- 本機能はLLVM拡張機能が必要（Clangフロントエンドを使用）
- GCC/Clang互換のコマンドライン構文をサポート
- クロスコンパイル時はバンドルされたlibc（glibc、musl、mingw）を自動使用
- ZIG_IS_DETECTING_LIBC_PATHS環境変数で再帰呼び出しを防止
- buildOutputType関数を.ccモードで呼び出して処理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ccコマンドはClangフロントエンドを呼び出すラッパーとして機能する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | ArgMode.cc列挙値とbuildOutputType関数 |
| 1-2 | clang_options.zig | `src/clang_options.zig` | Clangオプションの定義 |

**読解のコツ**: ccモードはbuildOutputType関数をArgMode.ccで呼び出し、Clangパススルーモードで動作する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | ccコマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | buildOutputType関数のccモード処理 |

**主要処理フロー**:
1. **300-302行目**: ccコマンドの検出とbuildOutputType呼び出し
2. **226-256行目**: libc検出時の再帰防止処理
3. **809行目以降**: buildOutputType関数でClangパススルー処理
4. **5784-5796行目**: clangMain関数でClang呼び出し

#### Step 3: Clang呼び出しを理解する

ClangへのFFI呼び出しの仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | clangMain関数 |
| 3-2 | bindings.zig | `src/codegen/llvm/bindings.zig` | ZigClang_main外部関数 |

**主要処理フロー**:
- **5773行目**: ZigClang_main外部関数宣言
- **5784-5796行目**: clangMain関数の実装

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [libc検出時の再帰防止] (226-256行目)
    │      │
    │      └─ ZIG_IS_DETECTING_LIBC_PATHS環境変数チェック
    │
    ├─ [ccコマンド検出] (300-302行目)
    │      │
    │      └─ dev.check(.cc_command)
    │
    └─ buildOutputType(.cc) (809行目以降)
           │
           ├─ [引数解析]
           │      │
           │      └─ ClangArgIteratorでClangオプション解析
           │
           ├─ Compilation.create()
           │
           └─ [Clangパススルーモード]
                  │
                  └─ clangMain() (5784行目)
                         │
                         ├─ argsCopyZ() - 引数をC形式に変換
                         │
                         └─ ZigClang_main() [FFI]
                                │
                                └─ Clang実装を呼び出し
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Cソースファイル ─────────▶ Clang (FFI) ────────────▶ オブジェクトファイル
     │
     │                    LLD (リンク)
     ▼
オブジェクトファイル ────▶ リンカ ─────────────────▶ 実行ファイル/ライブラリ
     │
     │                    libc選択
     ▼
ターゲット指定 ──────────▶ libc解決 ────────────────▶ glibc/musl/mingw
     │
     └────────────────────────────────────────────▶ 最終バイナリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとbuildOutputType関数 |
| clang_options.zig | `src/clang_options.zig` | ソース | Clangオプション定義 |
| clang_options_data.zig | `src/clang_options_data.zig` | ソース | Clangオプションデータ |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | Clang FFIバインディング |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理全般 |
| glibc.zig | `src/libs/glibc.zig` | ソース | glibcサポート |
| musl.zig | `src/libs/musl.zig` | ソース | muslサポート |
| mingw.zig | `src/libs/mingw.zig` | ソース | mingwサポート |
| dev.zig | `src/dev.zig` | ソース | cc_command機能フラグ |
