# 画面設計書 15-C++コンパイラ画面

## 概要

本ドキュメントは、Zigコンパイラの`zig c++`コマンドによるC++コンパイラ機能の画面設計書である。G++やClang++との互換性を持つドロップインC++コンパイラとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig c++`コマンドは、ZigをG++やClang++のドロップイン代替として使用するためのC++コンパイラツールである。C++ソースコードのコンパイル、リンク、各種プラットフォーム向けのクロスコンパイルを行う。

**業務上の目的・背景**：C++プロジェクトでは、ターゲットプラットフォームごとに異なるツールチェーンが必要であった。Zigのc++コマンドは単一のバイナリで多数のプラットフォーム向けにC++コードをクロスコンパイルできる。特に、libc++（C++標準ライブラリ）をバンドルしているため、追加のSDKなしでC++コードのクロスコンパイルが可能である。Zigプロジェクト内でC++ライブラリを利用する際にも、一貫したビルド環境を提供する。

**画面へのアクセス方法**：ターミナルから`zig c++ [options] source.cpp`コマンドを実行してアクセスする。G++/Clang++互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. C++ソースファイルのプリプロセス
2. C++コードのコンパイル（Clangフロントエンド使用）
3. オブジェクトファイルの生成
4. リンク処理（LLD使用、libc++リンク）
5. 実行ファイルまたはライブラリの生成

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | c++ | 主機能 | Zigをドロップイン C++コンパイラとして使用する処理 |
| 63 | libcxx | 補助機能 | C++標準ライブラリとの統合処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig c++ [options] source.cpp...
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| source files | 入力 | ファイルパス | 必須 | C++ソースファイル（複数可） |
| -o | 入力 | ファイルパス | 任意 | 出力ファイル名 |
| -c | 入力 | フラグ | 任意 | コンパイルのみ（リンクしない） |
| -target | 入力 | 文字列 | 任意 | ターゲットトリプル（例: x86_64-linux-gnu） |
| -O | 入力 | 文字列 | 任意 | 最適化レベル（0, 1, 2, 3, s, z） |
| -I | 入力 | ディレクトリパス | 任意 | インクルードパス追加 |
| -L | 入力 | ディレクトリパス | 任意 | ライブラリパス追加 |
| -l | 入力 | 文字列 | 任意 | リンクするライブラリ |
| -D | 入力 | 文字列 | 任意 | マクロ定義 |
| -std | 入力 | 文字列 | 任意 | C++言語標準（c++11, c++14, c++17, c++20等） |
| -W | 入力 | 文字列 | 任意 | 警告オプション |
| -f | 入力 | 文字列 | 任意 | 機能フラグ |
| -stdlib | 入力 | 文字列 | 任意 | 標準ライブラリ指定（libc++等） |
| 出力ファイル | 出力 | ファイル | - | 生成された実行ファイル/オブジェクト/ライブラリ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| コンパイルエラー | C++ソースの構文・意味エラー |
| リンクエラー | 未解決シンボル、ライブラリ不足等 |
| 警告メッセージ | コンパイラ警告 |
| verbose出力 | -v指定時の詳細コンパイル情報 |

## イベント仕様

### 1-コンパイルと実行ファイル生成

```
zig c++ -o hello hello.cpp
```

1. コマンドライン引数の解析
2. C++ソースのプリプロセス
3. Clangによるコンパイル
4. オブジェクトファイル生成
5. LLDによるリンク（libc++含む）
6. 実行ファイル出力

### 2-オブジェクトファイルのみ生成

```
zig c++ -c hello.cpp
```

1. コマンドライン引数の解析
2. C++ソースのプリプロセス
3. Clangによるコンパイル
4. オブジェクトファイル出力（リンクなし）

### 3-クロスコンパイル

```
zig c++ -target aarch64-linux-gnu -o hello hello.cpp
```

1. ターゲットプラットフォームの解決
2. 対応するlibc/libc++の選択
3. クロスコンパイル実行
4. ターゲット用バイナリ出力

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig cc` and `zig c++` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | エラー | error: {file}:{line}:{col}: {message} | コンパイルエラー発生時 |
| MSG003 | 警告 | warning: {file}:{line}:{col}: {message} | コンパイル警告発生時 |
| MSG004 | エラー | undefined reference to '{symbol}' | リンク時の未解決シンボル |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| ソースファイル未指定 | エラーメッセージを表示して終了 |
| 構文エラー | Clangエラーメッセージを表示して終了 |
| リンクエラー | LLDエラーメッセージを表示して終了 |
| ターゲット非対応 | サポートされていないターゲットとしてエラー |
| libc++未対応ターゲット | エラーまたは警告を表示 |

## 備考

- 本機能はLLVM拡張機能が必要（Clangフロントエンド使用）
- G++/Clang++互換のコマンドライン構文をサポート
- libc++をバンドルしており、クロスコンパイル時に自動使用
- zig ccと同じclangMain関数を使用（ArgMode.cpp）
- buildOutputType関数を.cppモードで呼び出して処理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

c++コマンドはClangフロントエンドを呼び出すラッパーとして機能する（ccと同様）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | ArgMode.cpp列挙値とbuildOutputType関数 |
| 1-2 | clang_options.zig | `src/clang_options.zig` | Clangオプションの定義 |

**読解のコツ**: cppモードはbuildOutputType関数をArgMode.cppで呼び出し、C++用の設定でClangを実行する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | c++コマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | buildOutputType関数のcppモード処理 |

**主要処理フロー**:
1. **303-305行目**: c++コマンドの検出とbuildOutputType呼び出し
2. **745行目**: ArgMode.cpp定義
3. **809行目以降**: buildOutputType関数でClangパススルー処理
4. **5784-5796行目**: clangMain関数でClang呼び出し

#### Step 3: ccとの差異を理解する

c++コマンドとccコマンドの差異を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | ArgMode.ccとArgMode.cppの処理分岐 |

**主要処理フロー**:
- ccとc++は同じclangMain関数を使用
- ArgModeの違いにより、Clangに渡すデフォルトオプションが異なる

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [c++コマンド検出] (303-305行目)
    │      │
    │      └─ dev.check(.cc_command) ← ccと同じフラグを使用
    │
    └─ buildOutputType(.cpp) (809行目以降)
           │
           ├─ [引数解析]
           │      │
           │      └─ ClangArgIteratorでClangオプション解析
           │
           ├─ [C++標準ライブラリ設定]
           │      │
           │      └─ libc++の自動リンク設定
           │
           ├─ Compilation.create()
           │
           └─ [Clangパススルーモード]
                  │
                  └─ clangMain() (5784行目)
                         │
                         ├─ argsCopyZ()
                         │
                         └─ ZigClang_main() [FFI]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

C++ソースファイル ───────▶ Clang (FFI) ────────────▶ オブジェクトファイル
     │
     │                    LLD (リンク) + libc++
     ▼
オブジェクトファイル ────▶ リンカ ─────────────────▶ 実行ファイル/ライブラリ
     │
     │                    libc/libc++選択
     ▼
ターゲット指定 ──────────▶ ライブラリ解決 ──────────▶ libc++ + libc
     │
     └────────────────────────────────────────────▶ 最終バイナリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとbuildOutputType関数 |
| clang_options.zig | `src/clang_options.zig` | ソース | Clangオプション定義 |
| clang_options_data.zig | `src/clang_options_data.zig` | ソース | Clangオプションデータ |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | Clang FFIバインディング |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理全般 |
| libcxx.zig | `src/libs/libcxx.zig` | ソース | libc++サポート（存在する場合） |
| dev.zig | `src/dev.zig` | ソース | cc_command機能フラグ |
