# 画面設計書 16-DLLツール画面

## 概要

本ドキュメントは、Zigコンパイラの`zig dlltool`コマンドによるDLLインポートライブラリ生成機能の画面設計書である。Windows用dlltool.exeとの互換性を持つドロップインツールとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig dlltool`コマンドは、ZigをWindows用dlltool.exeのドロップイン代替として使用するためのツールである。DLL（ダイナミックリンクライブラリ）のインポートライブラリ（.lib）を生成する。

**業務上の目的・背景**：Windows環境でDLLを使用する際、DLLに対応するインポートライブラリ（.lib）が必要となる。dlltoolはDEF（モジュール定義）ファイルからインポートライブラリを生成するツールである。Zigのdlltoolは、Windowsを含む任意のプラットフォームからWindows用のインポートライブラリを生成でき、クロスプラットフォーム開発を支援する。

**画面へのアクセス方法**：ターミナルから`zig dlltool [options]`コマンドを実行してアクセスする。GNU dlltool互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. DEFファイルの読み込み
2. エクスポートシンボルの解析
3. インポートライブラリ（.lib）の生成
4. オプションでDLL自体の生成

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | dlltool | 主機能 | ドロップインdlltool.exeとしてのDLLインポートライブラリ生成処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig dlltool [options]
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| -d, --input-def | 入力 | ファイルパス | 必須 | DEFファイル（モジュール定義） |
| -l, --output-lib | 入力 | ファイルパス | 任意 | 出力インポートライブラリ名 |
| -D, --dllname | 入力 | 文字列 | 任意 | DLL名（DEFファイルで指定がない場合） |
| -m, --machine | 入力 | 文字列 | 任意 | ターゲットマシン（i386, x64, arm等） |
| -k, --kill-at | 入力 | フラグ | 任意 | @nn接尾辞を削除 |
| --no-leading-underscore | 入力 | フラグ | 任意 | 先頭のアンダースコアを追加しない |
| インポートライブラリ | 出力 | ファイル | - | 生成された.libファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| エラーメッセージ | DEF解析エラーやファイル出力エラー |
| verbose出力 | 処理の詳細情報（-v指定時） |

## イベント仕様

### 1-インポートライブラリ生成

```
zig dlltool -d mylib.def -l mylib.lib
```

1. DEFファイルの読み込み
2. エクスポートシンボルの解析
3. COFF形式のインポートライブラリ生成
4. .libファイルの出力

### 2-クロスプラットフォーム生成

```
zig dlltool -d mylib.def -l mylib.lib -m x64
```

1. ターゲットマシンの指定
2. DEFファイルの読み込み
3. 指定アーキテクチャ用のインポートライブラリ生成

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig ar`, `zig dlltool`, `zig ranlib', and `zig lib` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | エラー | cannot open DEF file | DEFファイルが開けない場合 |
| MSG003 | エラー | invalid DEF file syntax | DEFファイルの構文エラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| DEFファイル未指定 | エラーメッセージを表示して終了 |
| DEFファイル読み込み失敗 | エラーメッセージを表示して終了 |
| 出力ファイル書き込み失敗 | エラーメッセージを表示して終了 |
| 不正なDEF構文 | エラーメッセージを表示して終了 |

## 備考

- 本機能はLLVM拡張機能が必要（llvm-arと同じバイナリを使用）
- GNU dlltool互換のコマンドライン構文をサポート
- zig ar、zig ranlib、zig libと同じllvmArMain関数を使用
- コマンド名（dlltool）が第一引数としてLLVMに渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

dlltoolコマンドはLLVMのllvm-ar内のdlltool機能を呼び出すため、Zig側のデータ構造は最小限である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | llvmArMain関数の引数形式 |

**読解のコツ**: dlltoolコマンドはarコマンドと同じ関数（llvmArMain）を使用し、コマンド名がLLVMに渡されることで適切な処理が選択される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | dlltool/ar/ranlib/libコマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | llvmArMain関数の実装 |

**主要処理フロー**:
1. **279-285行目**: dlltoolコマンドの検出とllvmArMain呼び出し
2. **5798-5810行目**: llvmArMain関数の実装
3. **5774行目**: ZigLlvmAr_main外部関数宣言

#### Step 3: コマンド分岐を理解する

LLVM側でコマンド名による処理分岐が行われる仕組みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | args[1..]で引数を渡す仕組み |

**主要処理フロー**:
- **5808行目**: args[1..]でzigコマンド自体を除外し、dlltoolをLLVMに渡す
- LLVM側でdlltoolコマンド名を検出してdlltool処理を実行

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [dlltool/ar/ranlib/libコマンド検出] (279-285行目)
    │      │
    │      └─ dev.check(.ar_command)
    │
    └─ llvmArMain() (5798行目)
           │
           ├─ [LLVM拡張チェック] (5799-5800行目)
           │
           ├─ ArenaAllocator初期化
           │
           ├─ argsCopyZ(args[1..]) (5808行目)
           │      │
           │      └─ "dlltool" がargv[0]として渡される
           │
           └─ ZigLlvmAr_main() [FFI]
                  │
                  └─ LLVM内でdlltool処理を実行
                         │
                         ├─ DEFファイル解析
                         │
                         └─ インポートライブラリ生成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DEFファイル ─────────────▶ llvmArMain() ────────────▶ コマンド引数変換
     │
     │                    ZigLlvmAr_main() [FFI]
     ▼
コマンド引数 ────────────▶ LLVM dlltool処理 ─────────▶ インポートライブラリ
     │
     │                    COFF形式生成
     ▼
エクスポート情報 ────────▶ シンボル変換 ────────────▶ .libファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとllvmArMain関数 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| build_options.zig | `src/build_options.zig` | 生成ファイル | have_llvmフラグ定義 |
| dev.zig | `src/dev.zig` | ソース | ar_command機能フラグ |
