# 画面設計書 17-Libツール画面

## 概要

本ドキュメントは、Zigコンパイラの`zig lib`コマンドによるWindows用静的ライブラリ作成機能の画面設計書である。Microsoft lib.exeとの互換性を持つドロップインツールとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig lib`コマンドは、ZigをMicrosoft lib.exeのドロップイン代替として使用するためのツールである。COFF形式の静的ライブラリ（.lib）を作成・管理する。

**業務上の目的・背景**：Windows環境での開発では、Visual Studioのlib.exeを使用して静的ライブラリを作成する。Zigのlibコマンドは、WindowsやVisual Studioがインストールされていない環境からでもWindows用の静的ライブラリを作成できる。これにより、LinuxやmacOSからのクロスプラットフォーム開発が容易になる。

**画面へのアクセス方法**：ターミナルから`zig lib [options] [files]`コマンドを実行してアクセスする。Microsoft lib.exe互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. オブジェクトファイルの読み込み
2. COFF形式の静的ライブラリ作成
3. シンボルテーブルの生成
4. ライブラリメンバーの追加・削除・抽出

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | lib | 主機能 | ドロップインlib.exeとしてのWindows用静的ライブラリ作成処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig lib [options] [files]
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| files | 入力 | ファイルパス | 必須 | 入力オブジェクトファイル（複数可） |
| /OUT: | 入力 | ファイルパス | 任意 | 出力ライブラリファイル名 |
| /DEF: | 入力 | ファイルパス | 任意 | DEFファイル（インポートライブラリ生成時） |
| /MACHINE: | 入力 | 文字列 | 任意 | ターゲットマシン（X86, X64, ARM等） |
| /NOLOGO | 入力 | フラグ | 任意 | バナー表示を抑制 |
| /LIST | 入力 | フラグ | 任意 | ライブラリメンバーを一覧表示 |
| /EXTRACT: | 入力 | 文字列 | 任意 | 指定メンバーを抽出 |
| /REMOVE: | 入力 | 文字列 | 任意 | 指定メンバーを削除 |
| 静的ライブラリ | 出力 | ファイル | - | 生成された.libファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| メンバー一覧 | ライブラリ内のオブジェクトファイル一覧（/LIST時） |
| エラーメッセージ | ファイル読み込みエラーやフォーマットエラー |
| verbose出力 | 処理の詳細情報 |

## イベント仕様

### 1-静的ライブラリ作成

```
zig lib /OUT:mylib.lib foo.obj bar.obj
```

1. オブジェクトファイルの読み込み
2. COFF形式の検証
3. ライブラリヘッダーの生成
4. シンボルテーブルの構築
5. .libファイルの出力

### 2-ライブラリ内容一覧表示

```
zig lib /LIST mylib.lib
```

1. ライブラリファイルの読み込み
2. メンバー情報の解析
3. メンバー名一覧の出力

### 3-メンバー抽出

```
zig lib /EXTRACT:foo.obj mylib.lib
```

1. ライブラリファイルの読み込み
2. 指定メンバーの検索
3. メンバーの抽出とファイル出力

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig ar`, `zig dlltool`, `zig ranlib', and `zig lib` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | エラー | cannot open input file | 入力ファイルが開けない場合 |
| MSG003 | エラー | invalid COFF object | 不正なCOFF形式の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| 入力ファイル未指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| 不正なCOFF形式 | エラーメッセージを表示して終了 |
| 出力ファイル書き込み失敗 | エラーメッセージを表示して終了 |

## 備考

- 本機能はLLVM拡張機能が必要（llvm-arと同じバイナリを使用）
- Microsoft lib.exe互換のコマンドライン構文をサポート
- zig ar、zig dlltool、zig ranlibと同じllvmArMain関数を使用
- コマンド名（lib）が第一引数としてLLVMに渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

libコマンドはLLVMのllvm-ar内のlib機能を呼び出すため、Zig側のデータ構造は最小限である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | llvmArMain関数の引数形式 |

**読解のコツ**: libコマンドはarコマンドと同じ関数（llvmArMain）を使用し、コマンド名がLLVMに渡されることで適切な処理が選択される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | lib/ar/dlltool/ranlibコマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | llvmArMain関数の実装 |

**主要処理フロー**:
1. **279-285行目**: libコマンドの検出とllvmArMain呼び出し
2. **5798-5810行目**: llvmArMain関数の実装
3. **5774行目**: ZigLlvmAr_main外部関数宣言

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [lib/ar/dlltool/ranlibコマンド検出] (279-285行目)
    │      │
    │      └─ dev.check(.ar_command)
    │
    └─ llvmArMain() (5798行目)
           │
           ├─ [LLVM拡張チェック] (5799-5800行目)
           │
           ├─ ArenaAllocator初期化
           │
           ├─ argsCopyZ(args[1..]) (5808行目)
           │      │
           │      └─ "lib" がargv[0]として渡される
           │
           └─ ZigLlvmAr_main() [FFI]
                  │
                  └─ LLVM内でlib処理を実行
                         │
                         ├─ COFF形式の解析
                         │
                         └─ 静的ライブラリ生成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

オブジェクトファイル ────▶ llvmArMain() ────────────▶ コマンド引数変換
     │
     │                    ZigLlvmAr_main() [FFI]
     ▼
.obj / .o ───────────────▶ LLVM lib処理 ─────────────▶ 静的ライブラリ
     │
     │                    COFF形式生成
     ▼
シンボル情報 ────────────▶ シンボルテーブル構築 ────▶ .libファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとllvmArMain関数 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| build_options.zig | `src/build_options.zig` | 生成ファイル | have_llvmフラグ定義 |
| dev.zig | `src/dev.zig` | ソース | ar_command機能フラグ |
