# 画面設計書 18-Ranlibツール画面

## 概要

本ドキュメントは、Zigコンパイラの`zig ranlib`コマンドによるアーカイブインデックス生成機能の画面設計書である。GNU ranlibとの互換性を持つドロップインツールとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig ranlib`コマンドは、ZigをGNU ranlibのドロップイン代替として使用するためのツールである。静的ライブラリ（アーカイブ）のシンボルインデックスを生成・更新する。

**業務上の目的・背景**：静的ライブラリ（.aファイル）は、リンク時にシンボルインデックスを使用して効率的にシンボルを検索する。ranlibはアーカイブにシンボルインデックスを追加または更新するツールである。Zigのranlibは、任意のプラットフォームからクロスプラットフォームでアーカイブのインデックスを操作できる。多くの場合、`ar s`オプションで同等の処理が可能であるが、ranlibは既存のビルドシステムとの互換性のために提供されている。

**画面へのアクセス方法**：ターミナルから`zig ranlib [archive]`コマンドを実行してアクセスする。GNU ranlib互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. アーカイブファイルの読み込み
2. 各メンバーのシンボル情報収集
3. シンボルインデックス（__SYMDEF等）の生成
4. アーカイブファイルの更新

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | ranlib | 主機能 | ドロップインranlibとしてのアーカイブインデックス生成処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig ranlib [options] archive
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| archive | 入力 | ファイルパス | 必須 | 処理対象のアーカイブファイル（.a） |
| -t | 入力 | フラグ | 任意 | インデックスのみ更新（タイムスタンプ更新なし） |
| -D | 入力 | フラグ | 任意 | 決定論的モード（タイムスタンプをゼロに） |
| -U | 入力 | フラグ | 任意 | 非決定論的モード（実際のタイムスタンプを使用） |
| 更新されたアーカイブ | 出力 | ファイル | - | インデックスが更新された.aファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| エラーメッセージ | ファイル読み込みエラーやフォーマットエラー |
| verbose出力 | 処理の詳細情報（-v指定時） |

## イベント仕様

### 1-シンボルインデックス生成

```
zig ranlib libfoo.a
```

1. アーカイブファイルの読み込み
2. 各オブジェクトメンバーの解析
3. 公開シンボルの収集
4. シンボルインデックステーブルの構築
5. アーカイブファイルの更新・上書き

### 2-決定論的モードでの更新

```
zig ranlib -D libfoo.a
```

1. アーカイブファイルの読み込み
2. タイムスタンプをゼロに設定
3. シンボルインデックスの生成
4. 再現可能なアーカイブの出力

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | `zig ar`, `zig dlltool`, `zig ranlib', and `zig lib` unavailable: compiler built without LLVM extensions | LLVM拡張なしでビルドされた場合 |
| MSG002 | エラー | cannot open archive | アーカイブファイルが開けない場合 |
| MSG003 | エラー | invalid archive format | 不正なアーカイブ形式の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| LLVM拡張なし | エラーメッセージを表示して終了 |
| アーカイブファイル未指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| 不正なアーカイブ形式 | エラーメッセージを表示して終了 |
| ファイル書き込み失敗 | エラーメッセージを表示して終了 |

## 備考

- 本機能はLLVM拡張機能が必要（llvm-arと同じバイナリを使用）
- GNU ranlib互換のコマンドライン構文をサポート
- zig ar、zig dlltool、zig libと同じllvmArMain関数を使用
- コマンド名（ranlib）が第一引数としてLLVMに渡される
- `ar s`オプションと機能的に同等

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ranlibコマンドはLLVMのllvm-ar内のranlib機能を呼び出すため、Zig側のデータ構造は最小限である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | llvmArMain関数の引数形式 |

**読解のコツ**: ranlibコマンドはarコマンドと同じ関数（llvmArMain）を使用し、コマンド名がLLVMに渡されることで適切な処理が選択される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | ranlib/ar/dlltool/libコマンドのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | llvmArMain関数の実装 |

**主要処理フロー**:
1. **279-285行目**: ranlibコマンドの検出とllvmArMain呼び出し
2. **5798-5810行目**: llvmArMain関数の実装
3. **5774行目**: ZigLlvmAr_main外部関数宣言

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [ranlib/ar/dlltool/libコマンド検出] (279-285行目)
    │      │
    │      └─ dev.check(.ar_command)
    │
    └─ llvmArMain() (5798行目)
           │
           ├─ [LLVM拡張チェック] (5799-5800行目)
           │
           ├─ ArenaAllocator初期化
           │
           ├─ argsCopyZ(args[1..]) (5808行目)
           │      │
           │      └─ "ranlib" がargv[0]として渡される
           │
           └─ ZigLlvmAr_main() [FFI]
                  │
                  └─ LLVM内でranlib処理を実行
                         │
                         ├─ アーカイブ解析
                         │
                         └─ シンボルインデックス更新
```

### データフロー図

```
[入力]                    [処理]                         [出力]

アーカイブファイル ──────▶ llvmArMain() ────────────▶ コマンド引数変換
     │
     │                    ZigLlvmAr_main() [FFI]
     ▼
.aファイル ──────────────▶ LLVM ranlib処理 ─────────▶ 更新されたアーカイブ
     │
     │                    シンボルインデックス生成
     ▼
各メンバーのシンボル ────▶ インデックステーブル構築 ─▶ __SYMDEF追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとllvmArMain関数 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| build_options.zig | `src/build_options.zig` | 生成ファイル | have_llvmフラグ定義 |
| dev.zig | `src/dev.zig` | ソース | ar_command機能フラグ |
