# 画面設計書 19-Objcopyツール画面

## 概要

本ドキュメントは、Zigコンパイラの`zig objcopy`コマンドによるオブジェクトファイル変換機能の画面設計書である。GNU objcopyとの互換性を持つドロップインツールとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig objcopy`コマンドは、ZigをGNU objcopyのドロップイン代替として使用するためのツールである。オブジェクトファイルの形式変換、セクション操作、デバッグ情報の操作を行う。

**業務上の目的・背景**：組み込み開発やシステムプログラミングでは、オブジェクトファイルを別の形式に変換したり、デバッグ情報を分離・削除したりする必要がある。objcopyはELF形式からバイナリ形式やIntel HEX形式への変換、デバッグシンボルの抽出などを行う。Zigのobjcopyは純粋なZig実装であり、LLVM拡張なしでも動作する。

**画面へのアクセス方法**：ターミナルから`zig objcopy [options] input output`コマンドを実行してアクセスする。GNU objcopy互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. 入力オブジェクトファイル（ELF）の読み込み
2. 出力形式の決定（ELF、バイナリ、Intel HEX）
3. セクションのフィルタリング・変換
4. デバッグ情報の操作（strip/only-keep-debug）
5. 出力ファイルの生成

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | objcopy | 主機能 | ドロップインobjcopyとしてのオブジェクトファイル変換処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig objcopy [options] input output
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| input | 入力 | ファイルパス | 必須 | 入力オブジェクトファイル |
| output | 入力 | ファイルパス | 必須 | 出力ファイル |
| -O, --output-target | 入力 | 文字列 | 任意 | 出力形式（binary, elf, hex） |
| -j, --only-section | 入力 | 文字列 | 任意 | 指定セクションのみ出力 |
| --pad-to | 入力 | 整数 | 任意 | 指定アドレスまでパディング |
| -g, --strip-debug | 入力 | フラグ | 任意 | デバッグセクションを削除 |
| -S, --strip-all | 入力 | フラグ | 任意 | 全てのシンボル・デバッグ情報を削除 |
| --only-keep-debug | 入力 | フラグ | 任意 | デバッグセクションのみ保持 |
| --compress-debug-sections | 入力 | フラグ | 任意 | デバッグセクションをzlibで圧縮 |
| --add-gnu-debuglink | 入力 | ファイルパス | 任意 | デバッグリンクセクションを追加 |
| --extract-to | 入力 | ファイルパス | 任意 | 削除されたセクションを抽出 |
| --add-section | 入力 | 文字列 | 任意 | セクションを追加（name=file形式） |
| --set-section-alignment | 入力 | 文字列 | 任意 | セクションのアラインメントを設定 |
| --set-section-flags | 入力 | 文字列 | 任意 | セクションのフラグを設定 |
| 出力ファイル | 出力 | ファイル | - | 変換されたオブジェクトファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| エラーメッセージ | ファイル読み込みエラーやフォーマットエラー |
| ヘルプ | -h指定時の使用方法説明 |

## イベント仕様

### 1-バイナリ形式への変換

```
zig objcopy -O binary input.elf output.bin
```

1. ELFファイルの読み込み
2. プログラムヘッダーの解析
3. ロード可能セグメントの抽出
4. 生バイナリデータの出力

### 2-Intel HEX形式への変換

```
zig objcopy -O hex input.elf output.hex
```

1. ELFファイルの読み込み
2. セグメント情報の解析
3. Intel HEXレコードの生成
4. .hexファイルの出力

### 3-デバッグ情報の削除

```
zig objcopy --strip-debug input.elf output.elf
```

1. ELFファイルの読み込み
2. デバッグセクションの識別（.debug_*等）
3. デバッグセクションを除外したELFの再構築
4. 出力ファイルの生成

### 4-デバッグ情報の分離

```
zig objcopy --only-keep-debug input.elf debug.elf
zig objcopy --strip-debug --add-gnu-debuglink=debug.elf input.elf output.elf
```

1. デバッグ情報のみを含むファイルを抽出
2. 元ファイルからデバッグ情報を削除
3. デバッグリンクセクションを追加

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | expected input parameter | 入力ファイルが未指定 |
| MSG002 | エラー | expected output parameter | 出力ファイルが未指定 |
| MSG003 | エラー | failed to open {file}: {error} | ファイルが開けない場合 |
| MSG004 | エラー | failed to stat {file}: {error} | ファイル情報取得失敗 |
| MSG005 | エラー | invalid elf file: {error} | 不正なELF形式 |
| MSG006 | エラー | invalid output format: {format} | サポートされていない出力形式 |
| MSG007 | エラー | zig objcopy: ELF to ELF copying only supports native endian | 非ネイティブエンディアンのELF変換 |
| MSG008 | エラー | zig objcopy: ELF to ELF copying only supports programs | プログラムヘッダーのないELF |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 入力ファイル未指定 | エラーメッセージを表示して終了 |
| 出力ファイル未指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| 不正なELF形式 | エラーメッセージを表示して終了 |
| サポート外の出力形式 | エラーメッセージを表示して終了 |
| 非ネイティブエンディアン | エラーメッセージを表示して終了 |

## 備考

- 本機能はZig純粋実装であり、LLVM拡張は不要
- jitCmd関数でlib/compiler/objcopy.zigをJITコンパイルして実行
- ELF形式の入力のみサポート
- 出力形式はELF、バイナリ（raw）、Intel HEX（hex）をサポート
- --listen=-オプションでビルドシステム統合モードをサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

objcopyはELFファイルを操作するため、ELFの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | objcopy.zig | `lib/compiler/objcopy.zig` | EmitRawElfOptions構造体とオプション定義 |
| 1-2 | elf.zig | `lib/std/elf.zig` | ELFヘッダーとセクション構造体 |

**読解のコツ**: objcopyは入力ELFを解析し、指定されたオプションに基づいて出力を生成する。EmitRawElfOptionsが主要な設定を保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | objcopyコマンドのディスパッチとjitCmd呼び出し |
| 2-2 | objcopy.zig | `lib/compiler/objcopy.zig` | main関数とcmdObjCopy関数 |

**主要処理フロー**:
1. **321-325行目**: objcopyコマンドの検出とjitCmd呼び出し
2. **objcopy.zig 20-24行目**: main関数でcmdObjCopyを呼び出し
3. **objcopy.zig 26-244行目**: cmdObjCopy関数の実装

#### Step 3: ELF解析処理を理解する

ELFファイルの読み込みと解析ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | objcopy.zig | `lib/compiler/objcopy.zig` | elf.Header.read()によるヘッダー解析 |
| 3-2 | objcopy.zig | `lib/compiler/objcopy.zig` | emitElf関数と出力形式別処理 |

**主要処理フロー**:
- **150-155行目**: ELFヘッダーの読み込み
- **178-209行目**: 出力形式に応じた処理分岐
- **292-358行目**: emitElf関数でのセグメント処理

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [objcopyコマンド検出] (321-325行目)
    │      │
    │      └─ jitCmd()でobjcopy.zigをJITコンパイル
    │
    └─ objcopy.zig (main関数)
           │
           └─ cmdObjCopy()
                  │
                  ├─ [引数解析] (43-141行目)
                  │      │
                  │      └─ 出力形式、オプションの解析
                  │
                  ├─ [ファイルオープン] (145-149行目)
                  │
                  ├─ elf.Header.read() (152-155行目)
                  │      │
                  │      └─ ELFヘッダーの読み込み
                  │
                  ├─ [出力形式判定] (159-169行目)
                  │
                  └─ emitElf() (191-195行目)
                         │
                         ├─ BinaryElfOutput.parse()
                         │
                         ├─ [raw形式] writeBinaryElfSection()
                         │
                         └─ [hex形式] HexWriter.writeSegment()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ELFファイル ─────────────▶ elf.Header.read() ────────▶ ヘッダー情報
     │
     │                    [オプション解析]
     ▼
オプション ──────────────▶ cmdObjCopy() ────────────▶ 出力形式決定
     │
     │                    emitElf()
     ▼
セグメント情報 ──────────▶ 形式変換 ─────────────────▶ 出力ファイル
     │
     ├─ [binary] ────────────────────────────────────▶ .bin (生バイナリ)
     │
     ├─ [hex] ───────────────────────────────────────▶ .hex (Intel HEX)
     │
     └─ [elf] ───────────────────────────────────────▶ .elf (変換後ELF)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとjitCmd呼び出し |
| objcopy.zig | `lib/compiler/objcopy.zig` | ソース | objcopyの主要実装 |
| elf.zig | `lib/std/elf.zig` | ソース | ELF形式の構造体定義 |
| Server.zig | `lib/std/zig/Server.zig` | ソース | ビルドシステム統合用サーバー |
