# 画面設計書 2-プロジェクトビルド画面

## 概要

本ドキュメントは、Zigコンパイラの「プロジェクトビルド画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

プロジェクトビルド画面は、`build.zig`ファイルに基づいてZigプロジェクト全体をビルドするCLI画面である。ビルドスクリプトを解釈し、プロジェクトの依存関係を解決しながらコンパイルを実行する。

**業務上の目的・背景**：Zigプロジェクトは複数のソースファイル、依存パッケージ、ビルドステップで構成される複雑な構造を持つことがある。`zig build`コマンドは、開発者が定義した`build.zig`スクリプトに従って、これらすべてを一貫した方法でビルドできるようにする。これにより、プロジェクトのビルドプロセスが再現可能で自動化しやすくなる。

**画面へのアクセス方法**：
- `zig build` - プロジェクトをビルド
- `zig build [ステップ名]` - 特定のビルドステップを実行
- `zig build --help` - ビルドオプションのヘルプを表示

**主要な操作・処理内容**：
1. `build.zig`ファイルの検索と読み込み
2. ビルドスクリプトのコンパイル
3. 依存パッケージの解決（`build.zig.zon`ベース）
4. ビルドステップの実行
5. ビルド成果物の生成

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：ビルド完了後にプロセス終了

**権限による表示制御**：権限による表示制御は存在しない。ファイルシステムへのアクセス権限がビルド可否を決定する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | build | 主機能 | build.zigに基づいてプロジェクトをビルドする処理 |
| 75 | 依存関係解決 | 補助機能 | build.zig.zonベースの依存関係解決処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

CLIアプリケーションのため、URLは存在しない。コマンドルーティングは以下の通り。

```
zig build [ステップ名] [オプション]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| ステップ名 | string | - | 実行するビルドステップ名（省略時はデフォルトステップ） |
| --build-file | string | - | build.zigファイルのパス |
| --zig-lib-dir | string | - | Zigライブラリディレクトリのパス |
| --cache-dir | string | - | ローカルキャッシュディレクトリ |
| --global-cache-dir | string | - | グローバルキャッシュディレクトリ |
| --color | auto/on/off | - | 色付き出力の制御 |
| -j | number | - | 並列ジョブ数 |
| --fetch | - | - | 依存パッケージの取得のみ実行 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルド進捗 | text | ビルドの進捗状況 |
| エラーメッセージ | text | コンパイルエラーや警告 |
| ビルド成果物 | binary | 生成された実行ファイル/ライブラリ等 |

## 表示項目

ビルド画面は以下の情報を表示する。

| セクション | 説明 |
|-----------|------|
| 進捗表示 | 現在のビルドステップと進捗 |
| コンパイルエラー | ソースコードのエラー情報 |
| リンクエラー | リンク時のエラー情報 |
| 依存関係情報 | 解決された依存パッケージ情報 |

## イベント仕様

### 1-ビルドコマンド実行

ユーザーが`zig build`を実行した場合。

**処理フロー**：
1. `cmdBuild`関数でコマンド引数を解析
2. `findBuildRoot`でbuild.zigの場所を特定
3. ビルドスクリプトをコンパイル
4. 依存パッケージを解決
5. ビルドステップを実行
6. 成果物を生成

### 2-依存関係取得

`--fetch`オプションが指定された場合。

**処理フロー**：
1. `build.zig.zon`を解析
2. 必要なパッケージをグローバルキャッシュにダウンロード
3. パッケージのハッシュを検証
4. 成功時にプロセス終了

## データベース更新仕様

本画面はデータベースを使用しない。ファイルシステム上のキャッシュを更新する。

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ビルド実行 | ローカルキャッシュ | CREATE/UPDATE | コンパイル済みオブジェクト、中間ファイルの保存 |
| 依存取得 | グローバルキャッシュ | CREATE | パッケージのダウンロードと保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 情報 | "Compile Build Script" | ビルドスクリプトコンパイル開始時 |
| - | エラー | "expected argument after '{s}'" | オプション引数不足時 |
| - | エラー | "unable to parse jobs count" | -jオプションの値が不正時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| build.zig未発見 | カレントディレクトリにbuild.zigがない | エラーメッセージを表示して終了 |
| コンパイルエラー | ソースコードに構文/意味エラー | エラー詳細を表示して終了 |
| 依存解決失敗 | パッケージが取得できない | エラーメッセージを表示して終了 |

## 備考

- ビルドスクリプトはホストターゲット向けにコンパイルされる
- 依存パッケージの取得にはHTTPクライアントが使用される
- キャッシュにより増分ビルドが高速化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルドコマンドで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `BuildRoot`構造体（7274-7278行目）：ビルドルート情報 |
| 1-2 | main.zig | `src/main.zig` | `FindBuildRootOptions`構造体（7285-7290行目）：ビルドルート検索オプション |
| 1-3 | Package.zig | `src/Package.zig` | パッケージ情報の構造体 |

**読解のコツ**: Zigのunion型や構造体のフィールド初期化に注意。オプショナルフィールドはnullで初期化される。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（286-288行目）：buildコマンドへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `cmdBuild`関数（4891-5190行目）：ビルドコマンドのメイン処理 |

**主要処理フロー**:
1. **4891行目**: `cmdBuild`関数開始
2. **4892行目**: `dev.check(.build_command)`でデバッグチェック
3. **4894-4917行目**: 各種変数の初期化
4. **4963-5098行目**: コマンドライン引数の解析
5. **5145-5148行目**: `findBuildRoot`でbuild.zigを検索
6. **5151-5163行目**: ディレクトリ情報の初期化
7. **5190行目〜**: ビルドループの開始

#### Step 3: ビルドルート検索を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | `findBuildRoot`関数（7290行目〜）：build.zigの検索ロジック |

**主要処理フロー**:
- ビルドファイルパスが指定されている場合はそれを使用
- 指定されていない場合はカレントディレクトリから親方向に検索

#### Step 4: 依存関係解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Package.zig | `src/Package.zig` | パッケージ解決ロジック |
| 4-2 | main.zig | `src/main.zig` | `Package.Fetch.JobQueue`（5186行目）：パッケージ取得キュー |

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ cmdBuild (4891行目)
                  │
                  ├─ dev.check(.build_command) (4892行目)
                  │
                  ├─ findBuildRoot (5145行目)
                  │      └─ build.zigファイル検索
                  │
                  ├─ Compilation.Directories.init (5151行目)
                  │      └─ ディレクトリパス初期化
                  │
                  ├─ Package.Fetch.JobQueue (5186行目)
                  │      └─ 依存パッケージ取得
                  │
                  └─ [ビルドスクリプト実行ループ] (5190行目〜)
                         └─ ビルドステップ実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

build.zig ─────────────▶ cmdBuild関数 ─────────────▶ ビルド成果物
   │                         │                          (.exe/.lib等)
   │                         ▼
   │                   findBuildRoot
   │                         │
   │                         ▼
   │                   ビルドスクリプトコンパイル
   │                         │
build.zig.zon ────────▶      │
   │                         ▼
   │                   依存関係解決
   │                         │
   │                         ▼
グローバルキャッシュ ◀── Package.Fetch
   │                         │
   │                         ▼
   └──────────────────▶ ビルドステップ実行
                             │
                             ▼
                       ローカルキャッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント、cmdBuild関数 |
| Package.zig | `src/Package.zig` | ソース | パッケージ管理、依存関係解決 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理の中核 |
| introspect.zig | `src/introspect.zig` | ソース | パス解決、環境検出 |
| build_options | (ビルド時生成) | 設定 | ビルド時オプション |
