# 画面設計書 20-RCツール画面

## 概要

本ドキュメントは、Zigコンパイラの`zig rc`コマンドによるWindowsリソースコンパイル機能の画面設計書である。Microsoft rc.exeとの互換性を持つドロップインツールとしてのCLIインターフェースを定義する。

### 本画面の処理概要

`zig rc`コマンドは、ZigをMicrosoft rc.exeのドロップイン代替として使用するためのWindowsリソースコンパイラツールである。.rcリソーススクリプトファイルをコンパイルし、.resファイルまたはCOFFオブジェクトファイルを生成する。

**業務上の目的・背景**：Windows GUIアプリケーションでは、アイコン、メニュー、ダイアログ、バージョン情報などのリソースを.rcファイルで定義する。rc.exeはこれらをバイナリ形式にコンパイルするMicrosoftの標準ツールである。Zigのrcコマンド（resinator）は、WindowsやVisual Studioがインストールされていない環境からでもWindowsリソースをコンパイルできる。LinuxやmacOSからのクロスコンパイルに対応している。

**画面へのアクセス方法**：ターミナルから`zig rc [options] input.rc [output]`コマンドを実行してアクセスする。Microsoft rc.exe互換のコマンドライン構文を使用する。

**主要な操作・処理内容**：
1. .rcリソーススクリプトの読み込み
2. プリプロセッサ（aro）によるマクロ展開・インクルード処理
3. リソーススクリプトの構文解析
4. リソースデータのコンパイル
5. .resファイルまたはCOFFオブジェクトの出力

**画面遷移**：本コマンドは独立したユーティリティであり、他の画面への遷移はない。コマンド完了後はシェルに戻る。

**権限による表示制御**：特になし。ファイルシステムの読み書き権限のみ必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | rc | 主機能 | ドロップインrc.exeとしてのWindowsリソースコンパイル処理 |

## 画面種別

コマンドライン・インターフェース（CLI）- 互換ツール

## URL/ルーティング

```
zig rc [options] input.rc [output]
```

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|-----------|-----|------|------|
| input | 入力 | ファイルパス | 必須 | 入力リソーススクリプト（.rc） |
| output | 入力 | ファイルパス | 任意 | 出力ファイル |
| /fo | 入力 | ファイルパス | 任意 | 出力ファイルパス指定 |
| /d | 入力 | 文字列 | 任意 | マクロ定義（name[=value]） |
| /u | 入力 | 文字列 | 任意 | マクロ定義解除 |
| /i | 入力 | ディレクトリパス | 任意 | インクルードパス追加 |
| /l | 入力 | 文字列 | 任意 | デフォルト言語ID（16進数） |
| /ln | 入力 | 文字列 | 任意 | デフォルト言語名（例: en-us） |
| /c | 入力 | 整数 | 任意 | デフォルトコードページ |
| /v | 入力 | フラグ | 任意 | 詳細出力モード |
| /x | 入力 | フラグ | 任意 | INCLUDE環境変数を無視 |
| /n | 入力 | フラグ | 任意 | 文字列テーブルをNULL終端 |
| /w | 入力 | フラグ | 任意 | 無効なコードページを警告として扱う |
| /y | 入力 | フラグ | 任意 | 重複コントロールIDの警告を抑制 |
| /sl | 入力 | 整数 | 任意 | 文字列リテラル長の上限（%） |
| /p | 入力 | フラグ | 任意 | プリプロセッサのみ実行 |
| /:no-preprocess | 入力 | フラグ | 任意 | プリプロセッサをスキップ |
| /:debug | 入力 | フラグ | 任意 | デバッグ出力を有効化 |
| /:auto-includes | 入力 | 文字列 | 任意 | 自動インクルードパス検出モード |
| /:depfile | 入力 | ファイルパス | 任意 | 依存関係ファイル出力 |
| /:input-format | 入力 | 文字列 | 任意 | 入力形式（rc/res/rcpp） |
| /:output-format | 入力 | 文字列 | 任意 | 出力形式（res/coff/rcpp） |
| /:target | 入力 | 文字列 | 任意 | ターゲットアーキテクチャ |
| リソースファイル | 出力 | ファイル | - | 生成された.resまたは.objファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| エラーメッセージ | 構文エラーやリソース処理エラー |
| 警告メッセージ | 重複ID、無効なコードページ等の警告 |
| verbose出力 | /v指定時の詳細処理情報 |
| ヘルプ | /?指定時の使用方法説明 |

## イベント仕様

### 1-リソーススクリプトのコンパイル

```
zig rc /fo output.res input.rc
```

1. 入力ファイルの読み込み
2. aroプリプロセッサによるマクロ展開
3. リソーススクリプトの構文解析
4. リソースデータのエンコード
5. .resファイルの出力

### 2-COFFオブジェクトへの変換

```
zig rc /:output-format coff /fo output.obj input.rc
```

1. リソーススクリプトのコンパイル
2. .resデータの生成
3. COFFオブジェクト形式への変換
4. .objファイルの出力

### 3-プリプロセスのみ実行

```
zig rc /p input.rc
```

1. プリプロセッサの実行
2. 展開されたソースの.rcppファイル出力

### 4-ビルドシステム統合モード

```
zig rc --zig-integration ...
```

1. サーバーモードで起動
2. 標準出力を介してビルドシステムと通信
3. エラー情報をErrorBundle形式で送信

## データベース更新仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムのみ操作）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| MSG001 | エラー | expected zig lib dir as first argument | 内部エラー（lib dirが未指定） |
| MSG002 | エラー | failed during preprocessing | プリプロセスエラー |
| MSG003 | エラー | failed during preprocessor setup | 内部セットアップエラー |
| MSG004 | エラー | maximum file size exceeded | ファイルサイズ超過 |
| MSG005 | 警告 | invalid code page in .rc | 無効なコードページ（/w指定時） |
| MSG006 | 警告 | duplicate control ID | 重複コントロールID |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 入力ファイル未指定 | エラーメッセージを表示して終了 |
| ファイル読み込み失敗 | エラーメッセージを表示して終了 |
| プリプロセスエラー | aroエラーメッセージを表示して終了 |
| 構文解析エラー | 詳細なエラー位置を表示して終了 |
| リソースエンコードエラー | エラーメッセージを表示して終了 |
| 無効なコードページ | 警告またはエラー（/wオプションに依存） |

## 備考

- 本機能はZig純粋実装（resinator）であり、LLVM拡張は不要
- jitCmd関数でlib/compiler/resinator/main.zigをJITコンパイルして実行
- aroプリプロセッサを使用してC/RCプリプロセスを処理
- Microsoft rc.exe互換のコマンドライン構文をサポート
- 独自オプションは「:」で始まる（例：/:debug）
- --zig-integrationオプションでビルドシステムサーバーモードをサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

resinatorsはWindowsリソースを処理するため、リソース形式の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.zig | `lib/compiler/resinator/cli.zig` | Options構造体とコマンドラインオプション定義 |
| 1-2 | res.zig | `lib/compiler/resinator/res.zig` | リソースデータ構造 |

**読解のコツ**: cli.zigのOptions構造体が主要な設定を保持する。入力/出力形式、プリプロセス設定、言語設定などが含まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | rcコマンドのディスパッチとjitCmd呼び出し |
| 2-2 | main.zig | `lib/compiler/resinator/main.zig` | resinatorsのメイン関数 |

**主要処理フロー**:
1. **309-317行目**: rcコマンドの検出とjitCmd呼び出し
2. **resinator/main.zig 21行目以降**: main関数の実装
3. **resinator/main.zig 69-94行目**: オプション解析

#### Step 3: プリプロセス処理を理解する

aroプリプロセッサの統合を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | preprocess.zig | `lib/compiler/resinator/preprocess.zig` | プリプロセッサ統合 |
| 3-2 | main.zig | `lib/compiler/resinator/main.zig` | プリプロセス実行部分 |

**主要処理フロー**:
- **main.zig 125-191行目**: プリプロセッサ実行とエラーハンドリング

#### Step 4: リソースコンパイル処理を理解する

リソーススクリプトの解析とコンパイルを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | compile.zig | `lib/compiler/resinator/compile.zig` | コンパイル処理 |
| 4-2 | parse.zig | `lib/compiler/resinator/parse.zig` | 構文解析 |

### プログラム呼び出し階層図

```
main.zig (mainArgs関数)
    │
    ├─ [rcコマンド検出] (309-317行目)
    │      │
    │      ├─ --zig-integration判定
    │      │
    │      └─ jitCmd()でresinator/main.zigをJITコンパイル
    │
    └─ resinator/main.zig (main関数)
           │
           ├─ [引数解析] cli.parse()
           │
           ├─ [プリプロセス] (125-191行目)
           │      │
           │      ├─ aro.Compilation.init()
           │      │
           │      └─ preprocess.preprocess()
           │
           ├─ [リソース解析]
           │      │
           │      ├─ parseAndRemoveLineCommands()
           │      │
           │      └─ compile()
           │
           └─ [出力]
                  │
                  ├─ [res形式] .resファイル出力
                  │
                  └─ [coff形式] cvtres.zigでCOFF変換
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.rcファイル ─────────────▶ aro.preprocess() ─────────▶ プリプロセス済みソース
     │
     │                    parse()
     ▼
プリプロセス済み ────────▶ リソース解析 ────────────▶ AST
     │
     │                    compile()
     ▼
AST ─────────────────────▶ エンコード ─────────────▶ リソースデータ
     │
     ├─ [res形式] ───────────────────────────────────▶ .resファイル
     │
     └─ [coff形式] ──────▶ cvtres.zig ──────────────▶ .objファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドディスパッチとjitCmd呼び出し |
| main.zig | `lib/compiler/resinator/main.zig` | ソース | resinatorsメイン |
| cli.zig | `lib/compiler/resinator/cli.zig` | ソース | コマンドラインオプション解析 |
| compile.zig | `lib/compiler/resinator/compile.zig` | ソース | リソースコンパイル |
| parse.zig | `lib/compiler/resinator/parse.zig` | ソース | リソーススクリプト構文解析 |
| lex.zig | `lib/compiler/resinator/lex.zig` | ソース | 字句解析 |
| preprocess.zig | `lib/compiler/resinator/preprocess.zig` | ソース | プリプロセッサ統合 |
| cvtres.zig | `lib/compiler/resinator/cvtres.zig` | ソース | COFF変換 |
| res.zig | `lib/compiler/resinator/res.zig` | ソース | リソースデータ構造 |
| errors.zig | `lib/compiler/resinator/errors.zig` | ソース | エラーハンドリング |
| aro.zig | `lib/compiler/aro/aro.zig` | ソース | aroプリプロセッサ |
