# 画面設計書 21-環境情報画面

## 概要

本ドキュメントは、Zigコンパイラの `zig env` コマンドによる環境情報画面の設計仕様を定義する。この画面は、Zigの実行環境に関する重要なパス情報とバージョン情報をJSON形式で出力する機能を提供する。

### 本画面の処理概要

環境情報画面は、開発者がZigコンパイラの設定やパス情報を確認するためのコマンドラインインターフェースである。ビルドシステムの設定、デバッグ、クロスコンパイル環境の構築などにおいて必要となる環境情報を一括取得できる。

**業務上の目的・背景**：Zigコンパイラを使用する開発者やビルドシステムが、現在のZig環境の設定状態を把握するために必要な機能である。特に、複数バージョンのZigを切り替えて使用する場合や、CI/CD環境でのビルド設定確認、ライブラリパスの問題解決時に重要な役割を果たす。また、外部ツールがZigの設定を自動検出する際にも活用される。

**画面へのアクセス方法**：ターミナルから `zig env` コマンドを実行することでアクセスする。追加のオプションや引数は不要で、即座に環境情報が標準出力に出力される。

**主要な操作・処理内容**：
1. Zig実行ファイル自身のパスを取得
2. Zigライブラリディレクトリのパスを特定
3. 標準ライブラリディレクトリのパスを計算
4. グローバルキャッシュディレクトリのパスを取得
5. ビルド時に設定されたバージョン情報を取得
6. ホストシステムのターゲットトリプルを生成
7. 環境変数による設定オーバーライドを確認
8. すべての情報をZON形式で標準出力に出力

**画面遷移**：本コマンドは独立した情報表示機能であり、他の画面への遷移は発生しない。`zig` コマンドのメインエントリポイントから直接呼び出される。

**権限による表示制御**：特に権限による制御は行われない。ファイルシステムへの読み取りアクセス権が必要となる場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | env | 主機能 | ライブラリパス、stdパス、キャッシュディレクトリ、バージョンの表示処理 |

## 画面種別

情報表示（CLI出力）

## URL/ルーティング

コマンド: `zig env`

## 入出力項目

### 入力項目

| No | 項目名 | 型 | 必須 | 説明 |
|----|--------|-----|------|------|
| - | なし | - | - | このコマンドは入力引数を受け取らない |

### 環境変数による設定オーバーライド

| 環境変数名 | 説明 |
|------------|------|
| ZIG_LIB_DIR | Zigライブラリディレクトリのパスを上書き |
| ZIG_GLOBAL_CACHE_DIR | グローバルキャッシュディレクトリのパスを上書き |

## 表示項目

出力はZON（Zig Object Notation）形式で以下の構造を持つ:

| No | フィールド名 | 型 | 説明 |
|----|-------------|-----|------|
| 1 | zig_exe | 文字列 | Zig実行ファイルの絶対パス |
| 2 | lib_dir | 文字列 | Zigライブラリディレクトリのパス |
| 3 | std_dir | 文字列 | 標準ライブラリディレクトリのパス |
| 4 | global_cache_dir | 文字列 | グローバルキャッシュディレクトリのパス |
| 5 | version | 文字列 | Zigのバージョン番号 |
| 6 | target | 文字列 | ホストシステムのターゲットトリプル |
| 7 | env | オブジェクト | 環境変数の設定状態 |

### 出力例

```zon
.{
    .zig_exe = "/usr/local/bin/zig",
    .lib_dir = "/usr/local/lib/zig",
    .std_dir = "/usr/local/lib/zig/std",
    .global_cache_dir = "/home/user/.cache/zig",
    .version = "0.14.0",
    .target = "x86_64-linux-gnu",
    .env = .{
        .ZIG_LIB_DIR = null,
        .ZIG_GLOBAL_CACHE_DIR = null,
        // ... その他の環境変数
    },
}
```

## イベント仕様

### 1-コマンド実行

ユーザーが `zig env` を実行すると、以下の処理が順次実行される:

1. `dev.check(.env_command)` で機能の有効性を確認
2. ホストターゲット情報を解決
3. 標準出力用ライターを初期化
4. `print_env.zig` の `cmdEnv` 関数を呼び出し
5. 環境情報をZON形式でシリアライズして出力
6. 出力バッファをフラッシュ

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| エラー | "unable to find zig self exe path: {t}" | 自身の実行ファイルパスの取得に失敗した場合 |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| 実行ファイルパス取得失敗 | 自身のパスを取得できない場合 | `fatal` でエラーメッセージを出力しプロセス終了 |
| ディレクトリ初期化失敗 | ディレクトリ情報の取得に失敗した場合 | エラーを上位に伝播 |

## 備考

- WASI環境では実行ファイルパスの取得方法が異なる（コマンドライン引数から取得）
- 環境変数 `ZIG_LIB_DIR` および `ZIG_GLOBAL_CACHE_DIR` で各ディレクトリのパスをオーバーライド可能
- 出力形式はZON（Zig Object Notation）であり、Zigコードで直接パース可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

環境情報として出力されるデータ構造と、環境変数による設定オーバーライドの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | `Directories` 構造体でパス情報がどのように管理されているか |
| 1-2 | build_options | ビルド時生成 | `version` などのビルド時定数の定義 |

**読解のコツ**: `EnvVar` 列挙型で定義された環境変数名を確認し、それぞれの用途を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるmain.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig env` コマンドの分岐処理（354-367行目） |

**主要処理フロー**:
1. **354行目**: `mem.eql(u8, cmd, "env")` でコマンド名を判定
2. **355行目**: `dev.check(.env_command)` で機能有効性確認
3. **356行目**: `std.zig.resolveTargetQueryOrFatal` でホストターゲット解決
4. **357行目**: 標準出力用ライターを初期化
5. **358-366行目**: `cmdEnv` 関数を呼び出し

#### Step 3: 環境情報出力処理を理解する

実際に環境情報を収集・出力する `cmdEnv` 関数の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | print_env.zig | `src/print_env.zig` | `cmdEnv` 関数の全体構造 |

**主要処理フロー**:
- **21-22行目**: 環境変数によるオーバーライド値を取得
- **24-29行目**: 自身の実行ファイルパスを取得（WASI対応あり）
- **31-40行目**: `Compilation.Directories` を初期化してパス情報を取得
- **43-46行目**: 各種パス情報を変数に格納
- **48-62行目**: ZONシリアライザを使用して構造化データを出力
- **58-60行目**: すべての環境変数を列挙して出力

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    ├─ dev.check(.env_command) [src/main.zig:355]
    │
    ├─ std.zig.resolveTargetQueryOrFatal() [src/main.zig:356]
    │
    └─ cmdEnv() [src/print_env.zig:12]
           │
           ├─ EnvVar.ZIG_LIB_DIR.get() [src/print_env.zig:21]
           │
           ├─ EnvVar.ZIG_GLOBAL_CACHE_DIR.get() [src/print_env.zig:22]
           │
           ├─ std.process.executablePathAlloc() [src/print_env.zig:26]
           │
           ├─ Compilation.Directories.init() [src/print_env.zig:31]
           │
           ├─ host.zigTriple() [src/print_env.zig:46]
           │
           └─ std.zon.Serializer (ZON出力) [src/print_env.zig:48-62]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

環境変数
 ZIG_LIB_DIR ────────┐
 ZIG_GLOBAL_CACHE ───┤
                     │
コマンドライン ───────┼──▶ cmdEnv() ───┬──▶ ZON形式で ───▶ 標準出力
 args[0] ────────────┤                │     シリアライズ
                     │                │
ビルド時定数 ─────────┤                │
 build_options ──────┘                │
                                      │
ホストシステム情報 ──────────────────────┘
 Target Query ──────▶ resolveTarget ─┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、コマンドディスパッチ |
| print_env.zig | `src/print_env.zig` | ソース | 環境情報収集・出力の実装 |
| Compilation.zig | `src/Compilation.zig` | ソース | Directories構造体の定義 |
| build_options | ビルド時生成 | 設定 | バージョン情報などのビルド時定数 |
