# 画面設計書 22-標準ライブラリドキュメント画面

## 概要

本ドキュメントは、Zigコンパイラの `zig std` コマンドによる標準ライブラリドキュメント画面の設計仕様を定義する。この画面は、ローカルHTTPサーバーを起動し、WebブラウザでZig標準ライブラリのインタラクティブなドキュメントを閲覧できる機能を提供する。

### 本画面の処理概要

標準ライブラリドキュメント画面は、開発者がZig標準ライブラリのAPIドキュメントをブラウザで閲覧するためのインターフェースである。ローカルにHTTPサーバーを起動し、WebAssemblyを使用したインタラクティブなドキュメントビューアを提供する。

**業務上の目的・背景**：Zig標準ライブラリの関数、型、モジュールについてのドキュメントを簡単に参照できる環境を提供する。オンラインドキュメントにアクセスできない環境でも、ローカルにインストールされたZigのバージョンに対応した正確なドキュメントを閲覧可能。WebAssemblyによるインタラクティブな検索とナビゲーション機能を備え、効率的なAPI探索を支援する。

**画面へのアクセス方法**：ターミナルから `zig std` コマンドを実行する。デフォルトでは自動的にWebブラウザが開かれ、ドキュメントページが表示される。ポート番号を指定して起動することも可能。

**主要な操作・処理内容**：
1. コマンドライン引数をパース（ポート番号、ブラウザ自動起動の制御）
2. 指定またはエフェメラルポートでHTTPサーバーを起動
3. 必要に応じてWebブラウザを自動起動
4. HTTPリクエストに応じて静的ファイル（HTML、JS）を配信
5. WebAssemblyバイナリをオンデマンドでビルド・配信
6. 標準ライブラリのソースコードをtar形式で配信
7. サーバーは手動で停止するまで継続動作

**画面遷移**：本コマンドは独立したドキュメントサーバー機能であり、他のCLIコマンドへの遷移は発生しない。ブラウザ内でのドキュメントページ間のナビゲーションはクライアントサイドで処理される。

**権限による表示制御**：特に権限による制御は行われない。HTTPサーバーは127.0.0.1（ローカルホスト）でのみリッスンし、外部からのアクセスは受け付けない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | std | 主機能 | ブラウザで標準ライブラリのドキュメントを表示する処理 |

## 画面種別

Webアプリケーション（ローカルHTTPサーバー + ブラウザ）

## URL/ルーティング

コマンド: `zig std [options]`

### HTTPエンドポイント

| パス | コンテンツタイプ | 説明 |
|------|-----------------|------|
| `/` | text/html | ドキュメントのメインページ |
| `/debug/` | text/html | デバッグモードのメインページ |
| `/main.js` | application/javascript | メインJavaScript |
| `/main.wasm` | application/wasm | ReleaseFastビルドのWASMモジュール |
| `/debug/main.wasm` | application/wasm | DebugビルドのWASMモジュール |
| `/sources.tar` | application/x-tar | 標準ライブラリソースコードのtarアーカイブ |

## 入出力項目

### 入力項目（コマンドライン引数）

| No | 項目名 | オプション | 型 | 必須 | 説明 |
|----|--------|-----------|-----|------|------|
| 1 | ヘルプ | -h, --help | - | × | ヘルプメッセージを表示 |
| 2 | ポート | -p, --port | u16 | × | リッスンするポート番号（デフォルト: 0=エフェメラル） |
| 3 | ブラウザ起動 | --open-browser | - | × | ブラウザの自動起動を強制有効化 |
| 4 | ブラウザ起動抑制 | --no-open-browser | - | × | ブラウザの自動起動を抑制 |

## 表示項目

### 標準出力

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | サーバーURL | HTTPサーバーがリッスンしているURL（例: `http://127.0.0.1:8080/`） |

### ブラウザ画面

WebAssemblyアプリケーションにより以下の機能が提供される:

- 標準ライブラリのモジュール一覧
- 関数・型・定数のAPIドキュメント
- インタラクティブな検索機能
- ソースコードの閲覧

## イベント仕様

### 1-コマンド実行

ユーザーが `zig std` を実行すると、以下の処理が順次実行される:

1. JITコンパイル経由で `std-docs.zig` がコンパイル・実行される
2. コマンドライン引数をパース
3. HTTPサーバーを指定ポートで起動
4. サーバーURLを標準出力に表示
5. 必要に応じてブラウザを自動起動
6. 無限ループでHTTPリクエストを待機・処理

### 2-HTTPリクエスト処理

各HTTPリクエストは並行処理され、以下のルーティングで対応:

1. `/` または `/debug/`: `docs/index.html` を配信
2. `/main.js`: `docs/main.js` を配信
3. `/main.wasm`: WebAssemblyモジュールをビルドして配信
4. `/sources.tar`: 標準ライブラリソースをtar形式で配信
5. その他: 404 Not Found

### 3-WebAssemblyビルド

`/main.wasm` へのリクエスト時:

1. `zig build-exe` を子プロセスとして実行
2. wasm32-freestanding ターゲットでビルド
3. グローバルキャッシュを利用してビルド結果をキャッシュ
4. ビルド完了後、バイナリをレスポンスとして返却

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 情報 | "source changes detected; rebuilt wasm component" | ソース変更によりWASMを再ビルドした場合 |
| エラー | "expected port number: {}" | ポート番号のパースに失敗した場合 |
| エラー | "unrecognized argument: {s}" | 不明な引数が指定された場合 |
| エラー | "unable to open browser: {t}" | ブラウザ起動に失敗した場合 |
| エラー | "closing http connection: {t}" | HTTP接続エラー |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| ポート番号パースエラー | 無効なポート番号が指定された場合 | ヘルプを表示して終了 |
| HTTPサーバー起動失敗 | ポートバインドに失敗した場合 | エラーを返却 |
| WASMビルドエラー | WebAssemblyのコンパイルに失敗した場合 | エラーログを出力 |
| ファイル読み込みエラー | 静的ファイルの読み込みに失敗した場合 | 500エラーを返却 |

## 備考

- HTTPサーバーは127.0.0.1でのみリッスンし、セキュリティリスクを軽減
- WebAssemblyモジュールはリクエストごとにリビルド可能（開発時の利便性）
- cache-control ヘッダーにより、ブラウザキャッシュを最小化
- サーバー停止にはプロセスを手動で終了する必要がある（Ctrl+C）
- JITコンパイルにより、初回起動時に若干の遅延が発生する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HTTPサーバーのコンテキストとリクエスト処理の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std-docs.zig | `lib/compiler/std-docs.zig` | Context構造体（125-132行目）でサーバー状態の管理方法を理解 |

**読解のコツ**: `Context` 構造体が持つ `lib_dir`, `zig_exe_path`, `global_cache_path` がWASMビルドとファイル配信の両方で使用される。

#### Step 2: エントリーポイントを理解する

main.zigでのJITコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig std` コマンドの分岐処理（334-341行目） |

**主要処理フロー**:
1. **334行目**: `mem.eql(u8, cmd, "std")` でコマンド名を判定
2. **335-341行目**: `jitCmd` 関数でJITコンパイル実行を設定
3. `root_src_path = "std-docs.zig"` で実行するスクリプトを指定
4. `prepend_zig_lib_dir_path = true` でライブラリパスを渡す

#### Step 3: HTTPサーバーの起動を理解する

std-docs.zigのmain関数でサーバー起動処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | std-docs.zig | `lib/compiler/std-docs.zig` | main関数（24-89行目） |

**主要処理フロー**:
- **29-34行目**: コマンドライン引数からパスを取得
- **39-57行目**: オプション引数のパース
- **60-64行目**: HTTPサーバーの起動
- **67-71行目**: ブラウザの自動起動
- **85-88行目**: リクエスト受付ループ

#### Step 4: リクエスト処理を理解する

各HTTPエンドポイントの処理ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | std-docs.zig | `lib/compiler/std-docs.zig` | serveRequest関数（134-160行目） |
| 4-2 | std-docs.zig | `lib/compiler/std-docs.zig` | serveWasm関数（246-279行目） |
| 4-3 | std-docs.zig | `lib/compiler/std-docs.zig` | buildWasmBinary関数（285-425行目） |

**主要処理フロー**:
- **135-139行目**: `/` または `/debug/` へのルーティング
- **144-147行目**: WASMモジュールの配信
- **295-318行目**: zig build-exe コマンドの構築
- **341-373行目**: ビルド結果の受信と解析

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    └─ jitCmd() [src/main.zig:5533]
           │
           └─ std-docs.zig::main() [lib/compiler/std-docs.zig:24]
                  │
                  ├─ HTTPサーバー起動 [lib/compiler/std-docs.zig:61]
                  │
                  ├─ openBrowserTab() [lib/compiler/std-docs.zig:438]
                  │
                  └─ accept() [lib/compiler/std-docs.zig:91]
                         │
                         └─ serveRequest() [lib/compiler/std-docs.zig:134]
                                │
                                ├─ serveDocsFile() [lib/compiler/std-docs.zig:167]
                                │
                                ├─ serveWasm() [lib/compiler/std-docs.zig:246]
                                │      │
                                │      └─ buildWasmBinary() [lib/compiler/std-docs.zig:285]
                                │             │
                                │             └─ std.process.spawn() (zig build-exe)
                                │
                                └─ serveSourcesTar() [lib/compiler/std-docs.zig:188]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数
 --port [num] ──────┐
 --open-browser ────┤
                    │
                    ▼
              main()でパース
                    │
                    ▼
              HTTPサーバー起動 ─────────▶ URL表示 ─▶ 標準出力
                    │
                    ▼
              ブラウザ自動起動 ────────▶ ブラウザ

HTTPリクエスト ─────▶ serveRequest() ─┬─▶ HTML/JS ─▶ HTTPレスポンス
                                      │
                                      ├─▶ WASM ───▶ HTTPレスポンス
                                      │    ↑
                                      │    │
                    zig build-exe ────┘    │
                                           │
                    lib/std/*.zig ─────────┴─▶ sources.tar
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、jitCmdへのディスパッチ |
| std-docs.zig | `lib/compiler/std-docs.zig` | ソース | HTTPサーバーとドキュメント配信の実装 |
| index.html | `lib/docs/index.html` | HTML | ドキュメントビューアのメインページ |
| main.js | `lib/docs/main.js` | JavaScript | クライアントサイドロジック |
| Walk.zig | `lib/docs/wasm/Walk.zig` | ソース | WASMモジュールの依存ファイル |
| wasm/main.zig | `lib/docs/wasm/main.zig` | ソース | WASMモジュールのエントリーポイント |
