# 画面設計書 23-libc情報画面

## 概要

本ドキュメントは、Zigコンパイラの `zig libc` コマンドによるlibc情報画面の設計仕様を定義する。この画面は、ネイティブまたは指定ターゲットのlibcインストール情報の検出・表示・検証機能を提供する。

### 本画面の処理概要

libc情報画面は、Zigコンパイラがクロスコンパイルや外部libc連携を行う際に必要となるlibcパス情報を管理するためのコマンドラインインターフェースである。ネイティブ環境のlibc設定を検出して出力したり、設定ファイルを検証したりできる。

**業務上の目的・背景**：Zigはビルトインのlibcサポートを持つが、特定の環境では外部libcを使用する必要がある。この画面は、ネイティブlibcの自動検出、クロスコンパイル用libc設定ファイルの作成支援、既存設定ファイルの検証を行う。特にCI/CD環境や組み込みシステム開発において、libc設定の正確な管理が求められる場面で活用される。

**画面へのアクセス方法**：ターミナルから `zig libc` コマンドを実行する。引数なしで実行するとネイティブlibcを検出し、ファイルパスを指定すると設定ファイルを検証する。

**主要な操作・処理内容**：
1. コマンドライン引数をパース（ターゲット、includesオプション、入力ファイル）
2. ターゲットトリプルを解決
3. `-includes` オプション時はlibcインクルードディレクトリを表示
4. 入力ファイル指定時は設定ファイルをパース・検証
5. 引数なし時はネイティブlibc情報を検出して出力

**画面遷移**：本コマンドは独立した情報表示・検証機能であり、他の画面への遷移は発生しない。

**権限による表示制御**：特に権限による制御は行われない。ネイティブlibc検出時はシステムのlibc関連ディレクトリへの読み取りアクセスが必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | libc | 主機能 | ネイティブlibcパスファイルの表示または検証処理 |

## 画面種別

情報表示・検証（CLI出力）

## URL/ルーティング

コマンド: `zig libc [options] [paths_file]`

## 入出力項目

### 入力項目（コマンドライン引数）

| No | 項目名 | オプション | 型 | 必須 | 説明 |
|----|--------|-----------|-----|------|------|
| 1 | ヘルプ | -h, --help | - | × | ヘルプメッセージを表示 |
| 2 | ターゲット | -target [name] | 文字列 | × | ターゲットトリプル（デフォルト: native） |
| 3 | インクルード表示 | -includes | - | × | libcインクルードディレクトリを表示 |
| 4 | パスファイル | [paths_file] | ファイルパス | × | 検証するlibc設定ファイル |

### 使用モード

| モード | 条件 | 動作 |
|--------|------|------|
| 検出モード | 引数なし、-includesなし | ネイティブlibcを検出して設定を出力 |
| 検証モード | paths_file指定 | 指定ファイルをパース・検証 |
| インクルード表示モード | -includes指定 | libcインクルードディレクトリを表示 |

## 表示項目

### 検出モード出力

libc設定情報がテキスト形式で出力される:

| No | フィールド名 | 説明 |
|----|-------------|------|
| 1 | include_dir | インクルードディレクトリパス |
| 2 | sys_include_dir | システムインクルードディレクトリパス |
| 3 | crt_dir | CRTライブラリディレクトリパス |
| 4 | msvc_lib_dir | MSVCライブラリディレクトリ（Windows） |
| 5 | kernel32_lib_dir | kernel32ライブラリディレクトリ（Windows） |

### インクルード表示モード出力

インクルードディレクトリが1行1パスで出力される。

## イベント仕様

### 1-ネイティブlibc検出

引数なしで `zig libc` を実行した場合:

1. ターゲットクエリが非ネイティブでないことを確認
2. `LibCInstallation.findNative` でシステムからlibc情報を検出
3. verbose=true で検出過程のログを出力
4. 検出結果を `libc.render()` で標準出力に出力

### 2-設定ファイル検証

`zig libc [paths_file]` で実行した場合:

1. 指定ファイルを `LibCInstallation.parse` でパース
2. パースエラーがあればエラーメッセージを出力
3. 成功すればサイレントに終了（出力なし）

### 3-インクルードディレクトリ表示

`zig libc -includes` で実行した場合:

1. 入力ファイルがあればそこからlibc情報を取得
2. なければネイティブターゲットのlibc情報を使用
3. `LibCDirs.detect` でインクルードディレクトリを検出
4. 各ディレクトリを1行ずつ出力

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| エラー | "expected parameter after {s}" | オプション引数が不足 |
| エラー | "unrecognized parameter: '{s}'" | 不明なオプション |
| エラー | "unexpected extra parameter: '{s}'" | 余分な引数 |
| エラー | "unable to parse libc file at path {s}: {t}" | 設定ファイルパースエラー |
| エラー | "unable to detect libc for non-native target" | 非ネイティブターゲットで検出試行 |
| エラー | "unable to detect native libc: {t}" | ネイティブlibc検出失敗 |
| エラー | "unable to detect libc for target {s}: {t}" | 指定ターゲットのlibc検出失敗 |
| エラー | "no include dirs detected for target {s}" | インクルードディレクトリなし |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| ターゲットパースエラー | 無効なターゲットトリプル | エラーメッセージを表示してプロセス終了 |
| ファイルパースエラー | 設定ファイルの形式が不正 | エラー詳細を出力してプロセス終了 |
| 検出失敗 | libcが見つからない | エラーメッセージを出力してプロセス終了 |

## 備考

- ネイティブlibc検出は `verbose = true` で詳細ログを出力
- 出力形式はZigの `--libc [file]` オプションで読み込み可能
- クロスコンパイル用libc設定ファイルの雛形として使用可能
- Windows環境ではMSVC関連のパスも検出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LibCInstallation構造体とlibc設定の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LibCInstallation | 標準ライブラリ | libcパス情報の構造体定義 |

**読解のコツ**: `LibCInstallation` は標準ライブラリ `std.zig.LibCInstallation` に定義されている。

#### Step 2: エントリーポイントを理解する

main.zigでのjitCmdディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig libc` コマンドの分岐処理（328-333行目） |

**主要処理フロー**:
1. **328行目**: `mem.eql(u8, cmd, "libc")` でコマンド名を判定
2. **329-333行目**: `jitCmd` でJITコンパイル実行
3. `root_src_path = "libc.zig"` で実行スクリプトを指定

#### Step 3: libc処理の実装を理解する

libc.zigのmain関数で主要ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | libc.zig | `lib/compiler/libc.zig` | main関数（27-135行目） |

**主要処理フロー**:
- **36-38行目**: 変数初期化（input_file, target_arch_os_abi, print_includes）
- **41-65行目**: 引数パースループ
- **67-70行目**: ターゲット解決
- **72-112行目**: -includes モードの処理
- **114-134行目**: 検出/検証モードの処理

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    └─ jitCmd() [src/main.zig:5533]
           │
           └─ libc.zig::main() [lib/compiler/libc.zig:27]
                  │
                  ├─ 引数パース [lib/compiler/libc.zig:41-65]
                  │
                  ├─ std.zig.parseTargetQueryOrReportFatalError() [67行目]
                  │
                  ├─ std.zig.resolveTargetQueryOrFatal() [70行目]
                  │
                  ├─ (includes モード)
                  │      │
                  │      ├─ LibCInstallation.parse() [76行目]
                  │      │
                  │      └─ std.zig.LibCDirs.detect() [87行目]
                  │
                  └─ (検出/検証モード)
                         │
                         ├─ LibCInstallation.parse() [115行目] (検証)
                         │
                         └─ LibCInstallation.findNative() [123行目] (検出)
                                │
                                └─ libc.render() [132行目]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数
 -target [name] ────┐
 -includes ─────────┤
 [paths_file] ──────┤
                    │
                    ▼
              main()でパース
                    │
            ┌───────┴───────┐
            │               │
            ▼               ▼
     -includes指定?    paths_file指定?
            │               │
     ┌──────┴──────┐  ┌─────┴─────┐
     │             │  │           │
     ▼             ▼  ▼           ▼
  LibCDirs     検出モード    検証モード
  .detect()        │           │
     │             │           │
     ▼             ▼           ▼
 インクルード    findNative()  parse()
 ディレクトリ       │           │
 一覧出力          ▼           ▼
              render()    (サイレント)
                  │
                  ▼
             設定情報出力 ─────────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、jitCmdへのディスパッチ |
| libc.zig | `lib/compiler/libc.zig` | ソース | libc情報検出・検証の実装 |
| LibCInstallation | 標準ライブラリ | ソース | libc設定情報の構造体定義 |
| LibCDirs | 標準ライブラリ | ソース | libcディレクトリ検出機能 |
