# 画面設計書 24-ターゲット一覧画面

## 概要

本ドキュメントは、Zigコンパイラの `zig targets` コマンドによるターゲット一覧画面の設計仕様を定義する。この画面は、Zigコンパイラがサポートするコンパイルターゲット（アーキテクチャ、OS、ABI）の完全な一覧をZON形式で出力する。

### 本画面の処理概要

ターゲット一覧画面は、クロスコンパイル設定やビルドシステム構成時に必要となるターゲット情報を網羅的に提供するコマンドラインインターフェースである。サポートされるすべてのCPUアーキテクチャ、OS、ABI、CPU機能、glibcバージョンなどを構造化されたデータとして出力する。

**業務上の目的・背景**：Zigはクロスコンパイルを第一級の機能として提供しており、開発者は多様なターゲットプラットフォーム向けにビルドできる。この画面は、利用可能なターゲットオプションを確認し、適切なターゲットトリプル（例: x86_64-linux-gnu）を選択するための情報源となる。CI/CDパイプラインでのマトリクスビルド設定や、組み込みシステム開発でのターゲット選定に活用される。

**画面へのアクセス方法**：ターミナルから `zig targets` コマンドを実行することでアクセスする。追加のオプションや引数は不要で、即座にターゲット情報が標準出力に出力される。

**主要な操作・処理内容**：
1. Zigライブラリディレクトリを検出
2. glibcのABIリストを読み込み
3. すべてのCPUアーキテクチャを列挙
4. すべてのOSタグを列挙
5. すべてのABIを列挙
6. 利用可能なlibc実装を列挙
7. glibcバージョン一覧を列挙
8. 各アーキテクチャのCPUモデルと機能を列挙
9. ネイティブシステムの情報を出力
10. すべての情報をZON形式で標準出力に出力

**画面遷移**：本コマンドは独立した情報表示機能であり、他の画面への遷移は発生しない。

**権限による表示制御**：特に権限による制御は行われない。Zigライブラリディレクトリへの読み取りアクセスが必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | targets | 主機能 | 利用可能なコンパイルターゲットの一覧表示処理 |

## 画面種別

情報表示（CLI出力）

## URL/ルーティング

コマンド: `zig targets`

## 入出力項目

### 入力項目

| No | 項目名 | 型 | 必須 | 説明 |
|----|--------|-----|------|------|
| - | なし | - | - | このコマンドは入力引数を受け取らない |

## 表示項目

出力はZON（Zig Object Notation）形式で以下の構造を持つ:

| No | フィールド名 | 型 | 説明 |
|----|-------------|-----|------|
| 1 | arch | 配列 | サポートされるCPUアーキテクチャ一覧 |
| 2 | os | 配列 | サポートされるOS一覧 |
| 3 | abi | 配列 | サポートされるABI一覧 |
| 4 | libc | 配列 | 利用可能なlibc実装（arch-os-abi形式） |
| 5 | glibc | 配列 | サポートされるglibcバージョン一覧 |
| 6 | cpus | オブジェクト | アーキテクチャ別のCPUモデルと機能マップ |
| 7 | cpu_features | オブジェクト | アーキテクチャ別のCPU機能一覧 |
| 8 | native | オブジェクト | ネイティブシステムの情報 |

### nativeオブジェクトの構造

| フィールド名 | 型 | 説明 |
|-------------|-----|------|
| triple | 文字列 | ネイティブターゲットトリプル |
| cpu.arch | 文字列 | CPUアーキテクチャ |
| cpu.name | 文字列 | CPUモデル名 |
| features | 配列 | 有効なCPU機能一覧 |
| os | 文字列 | オペレーティングシステム |
| abi | 文字列 | ABI |

### 出力例（抜粋）

```zon
.{
    .arch = .{ "aarch64", "aarch64_be", "arm", ... },
    .os = .{ "freestanding", "linux", "windows", ... },
    .abi = .{ "none", "gnu", "musl", ... },
    .libc = .{ "aarch64-linux-gnu", "aarch64-linux-musl", ... },
    .glibc = .{ "2.17", "2.18", "2.19", ... },
    .cpus = .{
        .x86_64 = .{
            .skylake = .{ "avx", "avx2", ... },
            ...
        },
        ...
    },
    .cpu_features = .{
        .x86_64 = .{ "adx", "aes", "avx", ... },
        ...
    },
    .native = .{
        .triple = "x86_64-linux-gnu",
        .cpu = .{
            .arch = "x86_64",
            .name = "skylake",
            .features = .{ "avx", "avx2", ... },
        },
        .os = "linux",
        .abi = "gnu",
    },
}
```

## イベント仕様

### 1-コマンド実行

ユーザーが `zig targets` を実行すると、以下の処理が順次実行される:

1. `dev.check(.targets_command)` で機能の有効性を確認
2. `std.zig.resolveTargetQueryOrFatal` でホストターゲットを解決
3. 標準出力用ライターを初期化
4. `print_targets.zig` の `cmdTargets` 関数を呼び出し
5. Zigライブラリディレクトリを検出
6. glibc ABIリストを読み込み
7. 各種ターゲット情報をZON形式でシリアライズして出力
8. 出力バッファをフラッシュ

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| エラー | "unable to find zig installation directory: {t}" | Zigライブラリディレクトリの検出に失敗した場合 |
| エラー | "unable to read {path}: {t}" | glibc ABIリストの読み込みに失敗した場合 |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| ライブラリディレクトリ検出失敗 | Zigインストールが見つからない | `fatal` でエラーメッセージを出力しプロセス終了 |
| ABIリスト読み込み失敗 | glibc情報ファイルが読めない | `fatal` でエラーメッセージを出力しプロセス終了 |
| メモリ不足 | 大量のターゲット情報でメモリ枯渇 | エラーを上位に伝播 |

## 備考

- 出力は構造化されたZON形式で、プログラムからのパースが容易
- CPU機能はアーキテクチャごとに異なる大量の項目が出力される
- glibcバージョン一覧はZigがサポートするすべてのバージョンを含む
- ネイティブターゲット情報は実行環境の自動検出結果を反映

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ターゲット情報の構造体定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std.Target | 標準ライブラリ | Target.Cpu.Arch, Target.Os.Tag, Target.Abi の列挙型 |
| 1-2 | glibc.zig | `src/libs/glibc.zig` | glibcメタデータの構造 |

**読解のコツ**: `std.Target` の各列挙型が出力されるフィールドに直接対応している。

#### Step 2: エントリーポイントを理解する

main.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig targets` コマンドの分岐処理（344-349行目） |

**主要処理フロー**:
1. **344行目**: `mem.eql(u8, cmd, "targets")` でコマンド名を判定
2. **345行目**: `dev.check(.targets_command)` で機能有効性確認
3. **346行目**: ホストターゲットを解決
4. **347行目**: 標準出力用ライターを初期化
5. **348行目**: `cmdTargets` 関数を呼び出し

#### Step 3: ターゲット出力処理を理解する

print_targets.zigの実装詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | print_targets.zig | `src/print_targets.zig` | `cmdTargets` 関数の全体構造 |

**主要処理フロー**:
- **23-26行目**: Zigライブラリディレクトリの検出
- **28-36行目**: glibc ABIリストの読み込み
- **39-40行目**: glibcメタデータのロード
- **42行目**: ZONシリアライザの初期化
- **47-49行目**: arch, os, abi フィールドの出力
- **51-59行目**: libc配列の出力
- **61-69行目**: glibc バージョン配列の出力
- **71-88行目**: cpus オブジェクトの出力（アーキテクチャ別CPUモデル）
- **90-100行目**: cpu_features オブジェクトの出力
- **102-131行目**: native オブジェクトの出力

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    ├─ dev.check(.targets_command) [src/main.zig:345]
    │
    ├─ std.zig.resolveTargetQueryOrFatal() [src/main.zig:346]
    │
    └─ cmdTargets() [src/print_targets.zig:15]
           │
           ├─ introspect.findZigLibDir() [src/print_targets.zig:23]
           │
           ├─ glibc.loadMetaData() [src/print_targets.zig:39]
           │
           ├─ std.zon.Serializer (ZON出力)
           │      │
           │      ├─ meta.fieldNames(Target.Cpu.Arch) [47行目]
           │      ├─ meta.fieldNames(Target.Os.Tag) [48行目]
           │      ├─ meta.fieldNames(Target.Abi) [49行目]
           │      ├─ std.zig.target.available_libcs [53行目]
           │      ├─ glibc_abi.all_versions [63行目]
           │      ├─ meta.tags(Target.Cpu.Arch) [73行目]
           │      └─ arch.allCpuModels() [75行目]
           │
           └─ native_target.zigTriple() [105行目]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Zigライブラリ
 glibc abilists ─────┐
                     │
                     ▼
              loadMetaData() ───┐
                                │
std.Target列挙型 ───────────────┼──▶ ZONシリアライザ ──▶ 標準出力
 Cpu.Arch ──────────────────────┤         │
 Os.Tag ────────────────────────┤         │
 Abi ───────────────────────────┤         │
                                │         │
std.zig.target                  │         │
 available_libcs ───────────────┤         │
                                │         │
ネイティブターゲット ────────────┘         │
 resolveTargetQuery ────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、コマンドディスパッチ |
| print_targets.zig | `src/print_targets.zig` | ソース | ターゲット情報収集・出力の実装 |
| glibc.zig | `src/libs/glibc.zig` | ソース | glibcメタデータ処理 |
| introspect.zig | `src/introspect.zig` | ソース | Zigインストールディレクトリの検出 |
| std.Target | 標準ライブラリ | ソース | ターゲット情報の列挙型定義 |
