# 画面設計書 25-バージョン画面

## 概要

本ドキュメントは、Zigコンパイラの `zig version` コマンドによるバージョン画面の設計仕様を定義する。この画面は、現在インストールされているZigコンパイラのバージョン番号を表示するシンプルな機能を提供する。

### 本画面の処理概要

バージョン画面は、Zigコンパイラのバージョン情報を即座に確認するための最も基本的なコマンドである。ビルド時に埋め込まれたバージョン文字列を標準出力に出力する。

**業務上の目的・背景**：開発環境のバージョン確認は、問題のトラブルシューティング、互換性の確認、ドキュメント参照時の正確なバージョン特定など、多くの場面で必要となる。特にCI/CD環境でのビルドログ記録、バグレポート作成時の環境情報収集、複数バージョンのZigを切り替えて使用する際の確認に活用される。

**画面へのアクセス方法**：ターミナルから `zig version` コマンドを実行することでアクセスする。追加のオプションや引数は不要で、即座にバージョン番号が出力される。

**主要な操作・処理内容**：
1. `dev.check(.version_command)` で機能の有効性を確認
2. ビルド時定数 `build_options.version` を取得
3. バージョン文字列に改行を付加して標準出力に出力

**画面遷移**：本コマンドは独立した情報表示機能であり、他の画面への遷移は発生しない。

**権限による表示制御**：特に権限による制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | version | 主機能 | バージョン番号の表示処理 |

## 画面種別

情報表示（CLI出力）

## URL/ルーティング

コマンド: `zig version`

## 入出力項目

### 入力項目

| No | 項目名 | 型 | 必須 | 説明 |
|----|--------|-----|------|------|
| - | なし | - | - | このコマンドは入力引数を受け取らない |

## 表示項目

| No | 項目名 | 型 | 説明 |
|----|--------|-----|------|
| 1 | バージョン番号 | 文字列 | セマンティックバージョニング形式（例: 0.14.0） |

### 出力例

```
0.14.0
```

## イベント仕様

### 1-コマンド実行

ユーザーが `zig version` を実行すると、以下の処理が順次実行される:

1. `dev.check(.version_command)` で機能の有効性を確認
2. `build_options.version` からビルド時に埋め込まれたバージョン文字列を取得
3. バージョン文字列に `\n` を付加して標準出力に出力

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

本コマンドはエラーメッセージを出力しない。

## 例外処理

本コマンドは例外的な状況が発生しない設計となっている。ビルド時定数を出力するだけのため、実行時エラーは発生しない。

## 備考

- バージョン番号はZigコンパイラのビルド時に `build_options` モジュールに埋め込まれる
- セマンティックバージョニング（major.minor.patch）形式で表現される
- 開発版ビルドでは追加のサフィックス（dev など）が付く場合がある
- 処理は非常に軽量で、ファイルI/Oやネットワークアクセスを行わない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バージョン情報がどのように定義されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build_options | ビルド時生成 | `version` 定数の定義場所 |

**読解のコツ**: `build_options` はビルドシステムによって生成されるモジュールで、`@import("build_options")` でアクセスする。

#### Step 2: エントリーポイントを理解する

main.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig version` コマンドの分岐処理（350-353行目） |

**主要処理フロー**:
1. **350行目**: `mem.eql(u8, cmd, "version")` でコマンド名を判定
2. **351行目**: `dev.check(.version_command)` で機能有効性確認
3. **352行目**: `build_options.version ++ "\n"` を標準出力に出力
4. **353行目**: 即座に `return` で処理終了

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    ├─ mem.eql(u8, cmd, "version") [src/main.zig:350]
    │
    ├─ dev.check(.version_command) [src/main.zig:351]
    │
    └─ Io.File.stdout().writeStreamingAll() [src/main.zig:352]
           │
           └─ build_options.version ++ "\n"
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                    ビルド時定数
                    build_options.version
                           │
                           ▼
                    文字列連結 ("\n"付加)
                           │
                           ▼
                    writeStreamingAll() ──────────▶ 標準出力
                                                   "0.14.0\n"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、コマンドディスパッチ |
| build_options | ビルド時生成 | 設定 | バージョン番号などのビルド時定数 |
